/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.asset;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.dto.asset.UseAssetListReqDto;
import com.digiwin.athena.http.asset.PermissionConditionResDto;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AssetDefinitionMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDefinitionMongoDao.class);
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    @Autowired
    public void setMongoPrimaryRepositoryDecorator(MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator) {
        this.mongoPrimaryRepositoryDecorator = mongoPrimaryRepositoryDecorator;
    }

    public AssetDefinition selectByApplicationAndCode(String code, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("manageContext.application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        return (AssetDefinition)this.mongoPrimaryRepositoryDecorator.findOne(query, AssetDefinition.class);
    }

    public void insert(AssetDefinition assetDefinition) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)assetDefinition);
    }

    public AssetDefinition selectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (AssetDefinition)this.mongoPrimaryRepositoryDecorator.findOne(query, AssetDefinition.class);
    }

    public void updateStatus(Integer status, String editBy, String assetId) {
        Update update = new Update();
        update.set("status", (Object)status);
        update.set("editDate", (Object)new Date());
        update.set("editBy", (Object)editBy);
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, AssetDefinition.class);
    }

    public void save(AssetDefinition assetDefinition) {
        this.mongoPrimaryRepositoryDecorator.save((Object)assetDefinition);
    }

    public List<AssetDefinition> selectByAssetIds(Collection<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectPagination(PageReqCondition<String> pageReqCondition, String tenantId, List<String> types, PermissionConditionResDto permissionConditionResDto) {
        Criteria perCriteria;
        Criteria criteria = this.buildPageCondition(pageReqCondition, tenantId, types);
        if (permissionConditionResDto != null && (perCriteria = this.buildPermissionConditionResDto(permissionConditionResDto)) != null) {
            Criteria newCriteria = new Criteria();
            newCriteria.andOperator(new Criteria[]{criteria, perCriteria});
            criteria = newCriteria;
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public Long countPagination(PageReqCondition<String> pageReqCondition, String tenantId, List<String> types, PermissionConditionResDto permissionConditionResDto) {
        Criteria perCriteria;
        Criteria criteria = this.buildPageCondition(pageReqCondition, tenantId, types);
        if (permissionConditionResDto != null && (perCriteria = this.buildPermissionConditionResDto(permissionConditionResDto)) != null) {
            Criteria newCriteria = new Criteria();
            newCriteria.andOperator(new Criteria[]{criteria, perCriteria});
            criteria = newCriteria;
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    private Criteria buildPermissionConditionResDto(PermissionConditionResDto permissionConditionResDto) {
        ArrayList<Criteria> conditions = new ArrayList<Criteria>();
        List fieldConditions = permissionConditionResDto.getChildren();
        if (!CollectionUtils.isEmpty((Collection)fieldConditions)) {
            for (PermissionConditionResDto.Condition fieldCondition : fieldConditions) {
                List values;
                if (fieldCondition.getOperator().equals("in")) {
                    values = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fieldCondition.getValue()), (TypeReference)new TypeReference<List>(){}, (Feature[])new Feature[0]);
                    conditions.add(Criteria.where((String)("manageContext." + fieldCondition.getField())).in((Collection)values));
                    continue;
                }
                if (fieldCondition.getOperator().equals("equal")) {
                    conditions.add(Criteria.where((String)("manageContext." + fieldCondition.getField())).is(fieldCondition.getValue()));
                    continue;
                }
                if (!fieldCondition.getOperator().equals("nin")) continue;
                values = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fieldCondition.getValue()), (TypeReference)new TypeReference<List>(){}, (Feature[])new Feature[0]);
                conditions.add(Criteria.where((String)("manageContext." + fieldCondition.getField())).nin((Collection)values));
            }
        } else {
            return null;
        }
        if (!conditions.isEmpty()) {
            Criteria criteria = new Criteria();
            if ("and".equals(permissionConditionResDto.getLogic())) {
                return criteria.andOperator(conditions);
            }
            if ("or".equals(permissionConditionResDto.getLogic())) {
                return criteria.orOperator(conditions);
            }
        }
        return null;
    }

    public Long countApplicationPagination(PageReqCondition<String> pageReqCondition, List<String> appCodes, List<String> types) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"manageContext.application").in(appCodes);
            if (!CollectionUtils.isEmpty(types)) {
                criteria = criteria.and("type").in(types);
            }
        } else {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(criteria);
            criteriaList.add(Criteria.where((String)"manageContext.application").in(appCodes));
            if (!CollectionUtils.isEmpty(types)) {
                criteriaList.add(Criteria.where((String)"type").in(types));
            }
            criteria = new Criteria().andOperator(criteriaList);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectApplicationPagination(PageReqCondition<String> pageReqCondition, List<String> appCodes, List<String> types) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"manageContext.application").is(appCodes);
            if (!CollectionUtils.isEmpty(types)) {
                criteria = criteria.and("type").in(types);
            }
        } else {
            Criteria criteria1 = Criteria.where((String)"manageContext.application").is(appCodes);
            if (!CollectionUtils.isEmpty(types)) {
                criteria1.and("type").in(types);
            }
            criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    private Criteria buildPageCondition(PageReqCondition<String> pageReqCondition, String tenantId, List<String> types) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        Criteria rangeCriteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)"openRange").is((Object)"all");
        Criteria criteria2 = Criteria.where((String)"openRange").is((Object)"curTenant").and("adpTenantId").is((Object)tenantId);
        Criteria criteria3 = Criteria.where((String)"openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{tenantId});
        rangeCriteria.orOperator(new Criteria[]{criteria3, criteria1, criteria2});
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(rangeCriteria);
        criteriaList.add(Criteria.where((String)"status").is((Object)1));
        if (!CollectionUtils.isEmpty(types)) {
            criteriaList.add(Criteria.where((String)"type").in(types));
        }
        if (criteria == null) {
            criteria = new Criteria();
            criteria.andOperator(criteriaList);
        } else {
            criteriaList.add(criteria);
            criteria = new Criteria().andOperator(criteriaList);
        }
        return criteria;
    }

    private Criteria buildAdvancedCondition(PageReqCondition<String> pageReqCondition) {
        Criteria adVancedCriteria;
        Criteria criteria = null;
        if (pageReqCondition.getAdvancedQueryParams() != null && (adVancedCriteria = pageReqCondition.getAdvancedQueryParams().buildCriteria()) != null) {
            criteria = adVancedCriteria;
        }
        if (criteria == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pageReqCondition.getCondition()))) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote((String)pageReqCondition.getCondition()) + ".*", 2);
            criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"assetId").regex(pattern), Criteria.where((String)"code").regex(pattern), Criteria.where((String)"assetName").regex(pattern), Criteria.where((String)"assetDesc").regex(pattern)});
        }
        return criteria;
    }

    public List<String> selectAssetIdAvailableStatusByApplication(String appCode, String type) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)appCode).and("status").is((Object)AssetDefinition.AVAILABLE_STATUS).and("type").is((Object)type);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class).stream().map(AssetDefinition::getAssetId).collect(Collectors.toList());
    }

    public Long countSameTenantDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        criteria = criteria == null ? Criteria.where((String)"adpTenantId").is((Object)tenantId).and("type").is((Object)type) : new Criteria().andOperator(new Criteria[]{Criteria.where((String)"adpTenantId").is((Object)tenantId), Criteria.where((String)"type").is((Object)type), criteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectSameTenantDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        criteria = criteria == null ? Criteria.where((String)"adpTenantId").is((Object)tenantId).and("type").is((Object)type) : new Criteria().andOperator(new Criteria[]{Criteria.where((String)"adpTenantId").is((Object)tenantId), Criteria.where((String)"type").is((Object)type), criteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public Long countPlatformDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{tenantId})});
        } else {
            Criteria criteria2 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{tenantId})});
            criteria = new Criteria().andOperator(new Criteria[]{criteria2, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectPlatformDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{tenantId})});
        } else {
            Criteria criteria2 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{tenantId})});
            criteria = new Criteria().andOperator(new Criteria[]{criteria2, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectBasicByApplicationAndCodes(String application, List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("manageContext.application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"assetId", "code", "type", "assetName", "manageContext.application"});
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectByAssetIdsAndStatus(List<String> assetIds, Integer status) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("status").is((Object)status);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public Long countAppUseAssetList(PageReqCondition<UseAssetListReqDto> pageReqCondition) {
        UseAssetListReqDto condition = (UseAssetListReqDto)pageReqCondition.getCondition();
        List<Criteria> criteriaList = AssetDefinitionMongoDao.buildAppUserAssetListCondition(condition);
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList));
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectAppUseAssetList(PageReqCondition<UseAssetListReqDto> pageReqCondition) {
        UseAssetListReqDto condition = (UseAssetListReqDto)pageReqCondition.getCondition();
        List<Criteria> criteriaList = AssetDefinitionMongoDao.buildAppUserAssetListCondition(condition);
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    private static List<Criteria> buildAppUserAssetListCondition(UseAssetListReqDto condition) {
        Criteria criteria;
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        Criteria criteria1 = new Criteria();
        criteria1.and("status").is((Object)AssetDefinition.AVAILABLE_STATUS);
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"canReference").is((Object)true), Criteria.where((String)"canCopy").is((Object)true)});
        criteriaList.add(criteria1);
        criteriaList.add(criteria2);
        if (!condition.getType().equals("ALL")) {
            Criteria criteria3 = new Criteria();
            criteria3.and("type").is((Object)condition.getType());
            criteriaList.add(criteria3);
        }
        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        if (condition.getRange().equals(UseAssetListReqDto.CUR_TENANT_RANGE)) {
            criteria = new Criteria();
            criteriaList.add(criteria);
            criteria.orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").is((Object)curTokenTenant.getTenantId()).and("openRange").is((Object)"all"), Criteria.where((String)"openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{curTokenTenant.getTenantId()}).and("adpTenantId").is((Object)curTokenTenant.getTenantId()), Criteria.where((String)"openRange").is((Object)"curTenant").and("adpTenantId").is((Object)curTokenTenant.getTenantId())});
        } else {
            criteria = new Criteria();
            criteriaList.add(criteria);
            criteria.orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)curTokenTenant.getTenantId()).and("openRange").is((Object)"all"), Criteria.where((String)"openRange").is((Object)"tenant").and("permission.tenantInfos.tenantId").in(new Object[]{curTokenTenant.getTenantId()}).and("adpTenantId").ne((Object)curTokenTenant.getTenantId())});
        }
        if (Boolean.TRUE.equals(condition.getCanCopy())) {
            criteria = new Criteria();
            criteriaList.add(criteria);
            criteria.and("canCopy").is((Object)true);
        }
        if (Boolean.TRUE.equals(condition.getCanReference())) {
            criteria = new Criteria();
            criteriaList.add(criteria);
            criteria.and("canReference").is((Object)true);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition.getSearchContent())) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(condition.getSearchContent()) + ".*", 2);
            Criteria criteria4 = new Criteria();
            criteriaList.add(criteria4);
            criteria4.orOperator(new Criteria[]{Criteria.where((String)"assetId").regex(pattern), Criteria.where((String)"assetName").regex(pattern), Criteria.where((String)"assetDesc").regex(pattern), Criteria.where((String)"publisherName").regex(pattern)});
        }
        return criteriaList;
    }

    public AssetDefinition selectByCodeAndType(String code, String type) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("type").is((Object)type);
        return (AssetDefinition)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), AssetDefinition.class);
    }

    public List<AssetDefinition> selectByCodesAndType(Collection codes, String type) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("type").is((Object)type);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetDefinition.class);
    }

    public List<String> selectAllAssetId() {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class).stream().map(AssetDefinition::getAssetId).collect(Collectors.toList());
    }

    public void delete(AssetDefinition assetDefinition) {
        this.mongoPrimaryRepositoryDecorator.delete((Object)assetDefinition);
    }
}

