/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assetType;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DAssetTypeMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DAssetTypeMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public List<AssetType> getAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Query query = DAssetTypeMongoDao.buildSearchCondition(pageReqCondition);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetType.class);
    }

    private static Query buildSearchCondition(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Criteria criteria = new Criteria();
        AssetTypeListConditionReqDto condition = (AssetTypeListConditionReqDto)pageReqCondition.getCondition();
        if (condition != null) {
            ArrayList<Criteria> andCondition = new ArrayList<Criteria>();
            if (!StringUtils.isEmpty((CharSequence)condition.getCategory())) {
                andCondition.add(Criteria.where((String)"category").and(condition.getCategory()));
            }
            if (!StringUtils.isEmpty((CharSequence)condition.getStatus())) {
                andCondition.add(Criteria.where((String)"status").and(condition.getStatus()));
            }
            if (!andCondition.isEmpty()) {
                criteria.andOperator(andCondition);
            }
            ArrayList<Criteria> orCondition = new ArrayList<Criteria>();
            if (!StringUtils.isEmpty((CharSequence)condition.getSearchContent())) {
                Pattern pattern = Pattern.compile(".*" + Pattern.quote(condition.getSearchContent()) + ".*", 2);
                orCondition.add(Criteria.where((String)"type").regex(pattern));
                orCondition.add(Criteria.where((String)"name").regex(pattern));
            }
            if (!orCondition.isEmpty()) {
                criteria.orOperator(orCondition);
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return query;
    }

    public Long countAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Query query = DAssetTypeMongoDao.buildSearchCondition(pageReqCondition);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetType.class);
    }

    public AssetType selectById(String objId) {
        Criteria criteria = Criteria.where((String)"_id").is((Object)objId);
        return (AssetType)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), AssetType.class);
    }

    public Long checkExistByNameExcludeType(String name, String excludeType) {
        Criteria criteria = Criteria.where((String)"name").is((Object)name).and("type").ne((Object)excludeType);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetType.class);
    }

    public void save(AssetType assetType) {
        this.mongoPrimaryRepositoryDecorator.save((Object)assetType);
    }

    public void insert(AssetType assetType) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)assetType);
    }

    public Long checkExistByType(String type) {
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetType.class);
    }

    public void delete(AssetType assetType) {
        this.mongoPrimaryRepositoryDecorator.delete((Object)assetType);
    }

    public List<AssetType> selectByStatus(List<String> status) {
        Criteria criteria = Criteria.where((String)"status").in(status);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"apiList", "openApiList", "dependencyRule", "metadata", "dataCollectConfig", "manageContextRule"});
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetType.class);
    }
}

