/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.SyncRuntime;
import com.digiwin.athena.service.assembly.DDesignerService;
import com.digiwin.athena.service.assembly.DSolutionPlanService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DDesignerServiceImpl
extends SyncRuntime<Designer>
implements DDesignerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDesignerServiceImpl.class);
    private final DDesignerMongoDao dDesignerMongoDao;
    private final RDesignerMongoDao rDesignerMongoDao;
    private final DSolutionPlanService solutionPlanService;
    private DDesignerServiceImpl proxyThis;

    @Override
    public Pagination<DesignerListDTO> findList(PageReqCondition<DesignerPageQo> param) {
        Pagination<DesignerListDTO> pagination = this.dDesignerMongoDao.selectPage(param);
        this.fillSolutionPlan(pagination);
        return pagination;
    }

    protected void fillSolutionPlan(Pagination<DesignerListDTO> pagination) {
        List<String> designerIds = pagination.getData().stream().map(DesignerListDTO::getId).collect(Collectors.toList());
        if (designerIds.isEmpty()) {
            return;
        }
        Map<String, Set<SolutionPlanListDTO>> solutionMap = this.solutionPlanService.findListByDesignerId(designerIds);
        for (DesignerListDTO designer : pagination.getData()) {
            Set<SolutionPlanListDTO> solutionPlan = solutionMap.get(designer.getId());
            designer.setRelatedSolutionPlan(SolutionConvertor.INSTANCE.toBaseDTO(solutionPlan));
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void save(Designer updated) {
        log.info("\u5f00\u59cb\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)updated.getName());
        this.checkUnique(updated);
        String objectId = updated.getId();
        if (objectId != null) {
            Designer existingBo = this.findExist(objectId);
            updated.removeUnmodifiable(existingBo.getStatus());
            DesignerConvertor.INSTANCE.merge(updated, existingBo);
            updated = existingBo;
        } else {
            updated.prepareNew();
        }
        this.dDesignerMongoDao.save(updated);
        log.info("\u6210\u529f\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)updated.getId());
    }

    protected void pureSave(Designer designer) {
        this.dDesignerMongoDao.save(designer);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Designer save(DesignerSaveDTO designer) {
        Designer bo = DesignerConvertor.INSTANCE.toBo(designer);
        this.save(bo);
        return bo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteById(String objectId) {
        log.info("\u5f00\u59cb\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)objectId);
        Designer existingBo = this.findExist(objectId);
        existingBo.checkDelete();
        this.dDesignerMongoDao.deleteById(objectId);
        log.info("\u6210\u529f\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)objectId);
    }

    protected void checkUnique(Designer designer) {
        if (!this.validateUnique(designer.getType(), designer.getName(), designer.getId())) {
            throw new BusinessException(Integer.valueOf(30000), "\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u552f\u4e00\uff01");
        }
    }

    protected Designer findExist(String objectId) {
        return Optional.ofNullable(this.dDesignerMongoDao.selectById(objectId)).orElseThrow(() -> new BusinessException(Integer.valueOf(30101), "\u8bbe\u8ba1\u5668\u4e0d\u5b58\u5728\uff01", new Object[]{objectId}));
    }

    @Override
    public DesignerDetailDTO findDetailById(String designerId) {
        Map<String, Set<SolutionPlanListDTO>> solutionMap = this.solutionPlanService.findListByDesignerId(Collections.singleton(designerId));
        DesignerDetailDTO dto = DesignerConvertor.INSTANCE.toDto(this.findById(designerId));
        dto.setRelatedSolutionPlan(SolutionConvertor.INSTANCE.toBaseDTO(solutionMap.get(designerId)));
        return dto;
    }

    @Override
    public Designer findById(String objectId) {
        log.debug("\u67e5\u8be2\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668\u8be6\u60c5: {}", (Object)objectId);
        return this.dDesignerMongoDao.selectById(objectId);
    }

    @Override
    public boolean validateUnique(String code, String name, String excludeObjectId) {
        return !this.dDesignerMongoDao.existsByKey(code, name, excludeObjectId);
    }

    @Override
    protected void saveDesignerTimeData(Designer syncData) {
        this.pureSave(syncData);
    }

    @Override
    protected void insertRunTimeData(Designer syncData) {
        this.rDesignerMongoDao.save(syncData);
    }

    @Override
    protected void saveRunTimeData(Designer syncData) {
        this.rDesignerMongoDao.save(syncData);
    }

    @Override
    protected Designer getDesignerTimeData(String objId) {
        return this.proxyThis.findById(objId);
    }

    @Override
    protected Designer getRunTimeData(String objId) {
        return this.rDesignerMongoDao.selectById(objId);
    }

    @Override
    protected void deleteRuntimeData(String objId) {
        this.rDesignerMongoDao.deleteById(objId);
    }

    @Autowired
    @Lazy
    public void setProxyThis(DDesignerServiceImpl proxyThis) {
        this.proxyThis = proxyThis;
    }

    @Generated
    public DDesignerServiceImpl(DDesignerMongoDao dDesignerMongoDao, RDesignerMongoDao rDesignerMongoDao, DSolutionPlanService solutionPlanService) {
        this.dDesignerMongoDao = dDesignerMongoDao;
        this.rDesignerMongoDao = rDesignerMongoDao;
        this.solutionPlanService = solutionPlanService;
    }
}

