package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@RequiredArgsConstructor
@Repository
public class RSolutionMongoDaoImpl implements RSolutionMongoDao {

    private static final SolutionConvertor CONVERTOR = SolutionConvertor.INSTANCE;
    private final MongoRuntimeRepositoryDecorator decorator;

    @Override
    public SolutionPlan selectById(String objectId) {
        AssemblyApplicationConfigEntity entity = decorator.findById(objectId, AssemblyApplicationConfigEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public Pagination<SolutionPlanListDTO> selectOnlineSolutionPage(PageReqCondition<RSolutionPlanPageQo> pageParam) {
        Query query = new Query();

        // 添加online状态条件
        query.addCriteria(Criteria.where(AssemblyApplicationConfigEntity.Fields.status).is(OnlineState.Online.getCode()));

        // 添加keyword查询条件
        RSolutionPlanPageQo condition = ObjectUtil.defaultIfNull(pageParam.getCondition(), RSolutionPlanPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());

        return decorator
                .findWithPage(query, AssemblyApplicationConfigEntity.class, pageParam)
                .convert(SolutionConvertor.INSTANCE::entityToListDTO);
    }

    @Override
    public void save(SolutionPlan solution) {
        AssemblyApplicationConfigEntity entity = CONVERTOR.toEntity(solution);
        entity.prepareSave();

        decorator.save(entity);

        solution.setId(entity.getId());
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query(Criteria.where(AssemblyApplicationConfigEntity.Fields.id).is(objectId));
        long count = decorator.remove(query, AssemblyApplicationConfigEntity.class);
        return count > 0;
    }
}
