package com.digiwin.athena.dto.assembly.designer;

import cn.hutool.core.date.DatePattern;
import com.digiwin.athena.common.dict.Dict;
import com.digiwin.athena.constants.enums.assembly.IntegrationType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assetType.AssetTypeBaseDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 设计器
 */
@Data
public class DesignerDetailDTO {

    /**
     * 主键ID
     */
    private String id;

    /**
     * 设计器编码，全局唯一
     */
    @NotBlank
    private String type;

    /**
     * 归属方
     */
    @NotBlank
    private String owner;

    /**
     * 设计器名称
     */
    @NotBlank
    private String name;

    /**
     * 版本号，service层暂时写死1.0
     */
    private String version;

    /**
     * 状态
     * @see OnlineState#getCode()
     */
    @Dict(enumClass = OnlineState.class)
    private String status;

    /**
     * 描述
     */
    private String description;

    /**
     * 关联的资产类型
     */
    private RelatedAssetTypeDTO relatedAssetType;

    /**
     * 关联的解决方案
     */
    private Set<SolutionPlanBaseDTO> relatedSolutionPlan;

    /**
     * API列表
     */
    private List<ApiBaseInfoDTO> apiList;

    /**
     * 集成方式：MF/microApp/Iframe
     * @see IntegrationType#getCode()
     */
    @Dict(enumClass = IntegrationType.class)
    private String integrationType;

    /**
     * 集成配置
     */
    private IntegrationConfigDTO integrationConfig;

    /**
     * 多语言配置
     */
    private Map<String, MultiLanguageDTO<String>> lang;

    /**
     * 发布时间
     */
    private Date publishTime;

    /**
     * 发布人
     */
    private String publishBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private LocalDateTime editTime;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 更新人
     */
    private String editBy;

    /**
     * 关联资产类型DTO
     */
    @Data
    public static class RelatedAssetTypeDTO {

        /**
         * 可读资产类型
         */
        private List<AssetTypeBaseDTO> read;

        /**
         * 可产生资产类型
         */
        private List<AssetTypeBaseDTO> write;
    }

    /**
     * API基础信息DTO
     */
    @Data
    public static class ApiBaseInfoDTO {

        /**
         * API key
         */
        private String key;

        /**
         * 描述
         */
        private String desc;

        /**
         * API名称
         */
        private String name;

        /**
         * 版本
         */
        private String version;

        /**
         * 租户ID
         */
        private String tenantId;
    }

    /**
     * 集成配置DTO
     */
    @Data
    public static class IntegrationConfigDTO {

        /**
         * 资源树模式url
         */
        private UrlDTO resourceTree;

        /**
         * 列表模式url
         */
        private UrlDTO list;
    }

    /**
     * URL DTO
     */
    @Data
    public static class UrlDTO {

        /**
         * 列表模式url
         */
        private String url;

        /**
         * 参数配置
         */
        private List<Map<String, Object>> params;
    }

}
