package com.digiwin.athena.mongodb.domain;

import com.digiwin.athena.utils.user.UserHelper;

import java.time.LocalDateTime;

public interface BaseMongoEntity<K> {
    K getId();

    String getCreateBy();

    void setCreateBy(String user);

    String getEditBy();

    void setEditBy(String user);


    LocalDateTime getCreateTime();

    void setCreateTime(LocalDateTime time);

    LocalDateTime getEditTime();

    void setEditTime(LocalDateTime time);


    default void prepareSave() {
        String userName = UserHelper.getCurrentUserNameOrSystem();
        LocalDateTime time = LocalDateTime.now();

        if (getId() == null) {
            setCreateBy(userName);
            setCreateTime(time);
        }

        setEditTime(time);
        setEditBy(userName);
    }
}
