package com.digiwin.athena.mongodb.domain.application;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "assetDepInfo")
@Data
public class AssetDepInfo {
    @Id
    private String objId;
    private String sourceId;

    private String targetType;
    private String targetCode;
    private String targetId;
    private String depType;
    private TargetContext  targetContext;

    @Data
    public static class TargetContext{
        private String application;
        private String branch;
        private String adpVersion;
    }
}
