/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service;

import com.digiwin.athena.mongodb.domain.PublishAble;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.Date;
import org.springframework.util.Assert;

public abstract class SyncRuntime<T extends PublishAble> {
    public T publish(String objId) {
        T designerTimeData = this.getDesignerTimeData(objId);
        Assert.notNull(designerTimeData, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u5e03\u6570\u636e");
        T runTimeData = this.getRunTimeData(objId);
        if (runTimeData != null) {
            this.deleteRuntimeData(objId);
        }
        designerTimeData.setStatus("online");
        designerTimeData.setPublishTime(new Date());
        UserHelper.fillEditInfo(designerTimeData);
        this.insertRunTimeData(designerTimeData);
        this.saveDesignerTimeData(designerTimeData);
        return designerTimeData;
    }

    public T takeDown(String objId) {
        T designerTimeData = this.getDesignerTimeData(objId);
        Assert.notNull(designerTimeData, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        Assert.notNull((Object)designerTimeData.getPublishTime(), (String)"\u672a\u53d1\u5e03\u65e0\u6cd5\u4e0b\u67b6");
        T runTimeData = this.getRunTimeData(objId);
        if (runTimeData != null) {
            runTimeData.setStatus("offline");
            UserHelper.fillEditInfo(runTimeData);
            this.saveRunTimeData(runTimeData);
        }
        designerTimeData.setStatus("offline");
        UserHelper.fillEditInfo(designerTimeData);
        this.saveDesignerTimeData(designerTimeData);
        return designerTimeData;
    }

    public T launch(String objId) {
        T designerTimeData = this.getDesignerTimeData(objId);
        Assert.notNull(designerTimeData, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        Assert.notNull((Object)designerTimeData.getPublishTime(), (String)"\u672a\u53d1\u5e03\u65e0\u6cd5\u4e0a\u67b6");
        T runTimeData = this.getRunTimeData(objId);
        if (runTimeData != null) {
            runTimeData.setStatus("online");
            UserHelper.fillEditInfo(runTimeData);
            this.saveRunTimeData(runTimeData);
        }
        designerTimeData.setStatus("online");
        UserHelper.fillEditInfo(designerTimeData);
        this.saveDesignerTimeData(designerTimeData);
        return designerTimeData;
    }

    protected abstract void saveDesignerTimeData(T var1);

    protected abstract void insertRunTimeData(T var1);

    protected abstract void saveRunTimeData(T var1);

    protected abstract T getDesignerTimeData(String var1);

    protected abstract T getRunTimeData(String var1);

    protected abstract void deleteRuntimeData(String var1);
}

