package com.digiwin.athena.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * Assembly模块配置属性
 */
@Configuration
@ConfigurationProperties(prefix = "assembly")
@Data
public class AssemblyProp {

    /**
     * 全局应用token
     */
    private String appToken;

    /**
     * IAM域名
     */
    private String iamDomain;

    /**
     * GMC域名
     */
    private String gmcDomain;

    /**
     * 解决方案logo url
     */
    private SolutionProp solution = new SolutionProp();

    /**
     * 商品类别代码（ODM/lcdp）
     */
    private String productCode = "lcdp";


    @Data
    public static class SolutionProp {
        private String gmcLogoImgUrl;
    }

    /**
     * 环境配置
     */
    @Data
    public static class EnvConfig {

        /**
         * IAM域名
         */
        private String iamDomain;

        /**
         * GMC域名
         */
        private String gmcDomain;
    }

}
