package com.digiwin.athena.dto.assembly.application;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.action.MultiLanguageDTO;

import java.util.Map;

/**
 * IAM应用请求参数工厂类
 */
public class IamApplicationRequestFactory {

    /**
     * 构建创建应用请求参数
     *
     * @param appId        应用ID
     * @param nameCN       中文名称
     * @param nameTW       繁体名称
     * @param nameUS       英文名称
     * @param logoImageUrl Logo地址
     * @param remarks      备注说明
     * @param sysCategory  系统分类
     * @param enableAuth   是否启用认证
     * @return 创建应用请求对象
     */
    public static IamCreateApplicationRequest buildCreateApplicationRequest(
            String appId, String nameCN, String nameTW, String nameUS,
            String logoImageUrl, String remarks, Integer sysCategory, Boolean enableAuth) {

        IamCreateApplicationRequest request = new IamCreateApplicationRequest();

        request.setId(appId);
        request.setNameCN(nameCN);
        request.setNameTW(nameTW);
        request.setNameUS(nameUS);
        request.setLogoImageUrl(logoImageUrl);
        request.setSysType(1);
        request.setRemarks(remarks);
        request.setNonDev(false);
        request.setCommon(0);
        request.setDevPlatform(0);
        request.setLandingApp(false);
        request.setSysCategory(sysCategory);
        request.setEnableAuth(enableAuth);

        return request;
    }

    /**
     * 构建IAM创建应用请求
     */
    public static IamCreateApplicationRequest buildIamApplicationRequest(SolutionPlan solutionPlan, String logoUrl) {
        IamCreateApplicationRequest request = new IamCreateApplicationRequest();

        // 设置应用ID（使用解决方案的type作为appId）
        request.setId(solutionPlan.getType());

        // 提取多语言名称
        Map<String, MultiLanguageDTO<String>> lang = solutionPlan.getLang();
        if (lang != null && lang.containsKey("name")) {
            MultiLanguageDTO<String> name = lang.get("name");
            request.setNameCN(name.getZh_CN());
            request.setNameTW(name.getZh_TW());
            request.setNameUS(name.getEn_US());
        } else {
            // 如果没有多语言配置，使用默认名称
            request.setNameCN(solutionPlan.getName());
            request.setNameTW(solutionPlan.getName());
            request.setNameUS(solutionPlan.getName());
        }

        // 设置其他固定参数
        request.setLogoImageUrl(logoUrl);
        request.setSysType(1);
        request.setRemarks(solutionPlan.getDescription());
        request.setNonDev(false);
        request.setCommon(0);
        request.setDevPlatform(0);
        request.setLandingApp(false);
        request.setSysCategory(1);
        request.setEnableAuth(null);
        return request;
    }
}
