package com.digiwin.athena.dto.assembly.goods;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.utils.user.UserHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * GMC商品请求参数工厂类
 */
public class GmcCommodityRequestFactory {

    /**
     * 构建创建商品请求
     *
     * @param appId 应用ID
     * @param productCode 商品类别（ODM/lcdp）
     * @return 创建商品请求对象
     */
    public static CreateCommodityRequest buildCreateRequest(
            String appId, String productCode) {

        CreateCommodityRequest request = new CreateCommodityRequest();

        request.setSysId(appId);
        request.setPlatformCode("Athena");
        request.setPaymentType("人/月");
        request.setTenancyPeriod("12");
        request.setProductCode(productCode);
        request.setUsersNumber("50");
        request.setUserNumberCode("0");
        request.setShowConsole(false);
        request.setPmEmails(UserHelper.getCurrentUserNameOrSystem());

        return request;
    }

    /**
     * 构建更新模组请求
     *
     * @param appId 应用ID
     * @param appName 应用名称
     * @param curAppToken 应用token
     * @param moduleList 模组列表
     * @return 更新模组请求对象
     */
    public static UpdateModulesRequest buildUpdateModulesRequest(
            String appId, String appName, String curAppToken, List<ModuleItem> moduleList) {

        UpdateModulesRequest request = new UpdateModulesRequest();
        request.setCode(appId);

        AppInfo appInfo = new AppInfo();
        appInfo.setCategoryId(appId);
        appInfo.setId(appId);
        appInfo.setName(appName);
        appInfo.setIsMultiLogin(0);

        ModulesInfo modulesInfo = new ModulesInfo();
        modulesInfo.setAppToken(curAppToken);
        modulesInfo.setApp(appInfo);
        modulesInfo.setModules(moduleList);
        modulesInfo.setActions(new ArrayList<>());

        request.setModules(modulesInfo);

        LanguageData customUnit = new LanguageData();
        customUnit.setFieldName("customunit");
        customUnit.setContent("次");

        LanguageData goodsName = new LanguageData();
        goodsName.setFieldName("goodsName");
        goodsName.setContent(appName);

        LanguageData modulesJSON = new LanguageData();
        modulesJSON.setFieldName("modules");
        modulesJSON.setContent(JSON.toJSONString(modulesInfo));

        MultiLanguageResource zhCNLanguage = new MultiLanguageResource();
        zhCNLanguage.setLanguage("zh-CN");
        zhCNLanguage.setData(ListUtil.toList(customUnit, goodsName, modulesJSON));

        request.setMultiLanguageResource(ListUtil.toList(zhCNLanguage));

        return request;
    }

    /**
     * 创建模组项（工具方法）
     *
     * @param id 模组ID
     * @param name 模组名称
     * @return 模组项对象
     */
    public static ModuleItem createModule(String id, String name) {
        ModuleItem module = new ModuleItem();
        module.setId(id);
        module.setName(name);
        return module;
    }
}
