package com.digiwin.athena.mongodb.domain.assembly;

import com.digiwin.athena.constants.enums.assembly.IntegrationType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.mongodb.domain.BaseMongoEntity;
import lombok.Data;
import lombok.experimental.FieldNameConstants;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 设计器
 */
@Data
@FieldNameConstants
@Document(collection = "designer")
public class DesignerEntity implements BaseMongoEntity<String> {

    /**
     * 主键ID
     */
    @Id
    private String id;

    /**
     * 设计器编码，全局唯一
     */
    private String type;

    /**
     * 归属方
     */
    private String owner;

    /**
     * 设计器名称
     */
    private String name;

    /**
     * 版本号，service层暂时写死1.0
     */
    private String version;

    /**
     * 版本排序，version根据`.`分割，{第一部分}*1000+{第二部分}
     */
    private Integer versionSort;

    /**
     * 状态
     *
     * @see OnlineState#getCode()
     */
    private String status;

    /**
     * 描述
     */
    private String description;

    /**
     * 关联的资产类型
     */
    private DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType;

    /**
     * 关联解决方案
     */
    private List<SolutionPlanBaseDTO> relatedSolutionPlan;

    /**
     * API列表
     */
    private List<DesignerDetailDTO.ApiBaseInfoDTO> apiList;

    /**
     * 集成方式：MF/microApp/Iframe
     *
     * @see IntegrationType#getCode()
     */
    private String integrationType;

    /**
     * 集成配置
     */
    private DesignerDetailDTO.IntegrationConfigDTO integrationConfig;

    /**
     * 多语言配置
     */
    private Map<String, MultiLanguageDTO<String>> lang;

    /**
     * 发布时间
     */
    private LocalDateTime publishTime;

    /**
     * 发布人
     */
    private String publishBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime editTime;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 更新人
     */
    private String editBy;
}
