/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.assembly.application;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.application.IamCreateApplicationRequest;
import java.util.Map;

public class IamApplicationRequestFactory {
    public static IamCreateApplicationRequest buildCreateApplicationRequest(String appId, String nameCN, String nameTW, String nameUS, String logoImageUrl, String remarks, Integer sysCategory, Boolean enableAuth) {
        IamCreateApplicationRequest request = new IamCreateApplicationRequest();
        request.setId(appId);
        request.setNameCN(nameCN);
        request.setNameTW(nameTW);
        request.setNameUS(nameUS);
        request.setLogoImageUrl(logoImageUrl);
        request.setSysType(1);
        request.setRemarks(remarks);
        request.setNonDev(false);
        request.setCommon(0);
        request.setDevPlatform(0);
        request.setLandingApp(false);
        request.setSysCategory(sysCategory);
        request.setEnableAuth(enableAuth);
        return request;
    }

    public static IamCreateApplicationRequest buildIamApplicationRequest(SolutionPlan solutionPlan, String logoUrl) {
        IamCreateApplicationRequest request = new IamCreateApplicationRequest();
        request.setId(solutionPlan.getType());
        Map<String, MultiLanguageDTO<String>> lang = solutionPlan.getLang();
        if (lang != null && lang.containsKey("name")) {
            MultiLanguageDTO<String> name = lang.get("name");
            request.setNameCN((String)name.getZh_CN());
            request.setNameTW((String)name.getZh_TW());
            request.setNameUS((String)name.getEn_US());
        } else {
            request.setNameCN(solutionPlan.getName());
            request.setNameTW(solutionPlan.getName());
            request.setNameUS(solutionPlan.getName());
        }
        request.setLogoImageUrl(logoUrl);
        request.setSysType(1);
        request.setRemarks(solutionPlan.getDescription());
        request.setNonDev(false);
        request.setCommon(0);
        request.setDevPlatform(0);
        request.setLandingApp(false);
        request.setSysCategory(1);
        request.setEnableAuth(null);
        return request;
    }
}

