/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.application.IamCreateApplicationResponse;
import com.digiwin.athena.dto.assembly.goods.CreateCommodityRequest;
import com.digiwin.athena.dto.assembly.goods.UpdateModulesRequest;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class GmcCommodityService {
    private final AssemblyProp assemblyProp;

    public void createCommodity(CreateCommodityRequest request, List<IamCreateApplicationResponse> appInfo) {
        for (IamCreateApplicationResponse response : appInfo) {
            AssemblyProp.EnvConfig envConfig = response.getEnvConfig();
            String iamToken = response.getToken();
            String gmcDomain = envConfig.getGmcDomain();
            String url = gmcDomain + "/api/cloudgoods/auto/deploy";
            String responseBody = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(BaseConverter.INSTANCE.serialize(request)).header("digi-middleware-auth-user", iamToken)).header("digi-middleware-auth-app", this.assemblyProp.getAppToken())).execute().body();
            Map responseObj = BaseConverter.INSTANCE.deserialize(responseBody, Map.class);
            Boolean success = MapUtil.getBool((Map)responseObj, (Object)"success");
            if (success.booleanValue()) continue;
            throw new BusinessException("GMC failed to create the product, error message:" + MapUtil.getStr((Map)responseObj, (Object)"errorMessage"));
        }
    }

    public void updateModules(UpdateModulesRequest request, List<IamCreateApplicationResponse> appInfo) {
        for (IamCreateApplicationResponse response : appInfo) {
            AssemblyProp.EnvConfig envConfig = response.getEnvConfig();
            String token = response.getToken();
            String gmcUrl = envConfig.getGmcDomain() + "/api/cloudgoods/modules";
            try {
                String responseBody = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)gmcUrl).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.assemblyProp.getAppToken())).body(BaseConverter.INSTANCE.serialize(request)).execute().body();
                Map responseObj = BaseConverter.INSTANCE.deserialize(responseBody, Map.class);
                Integer code = MapUtil.getInt((Map)responseObj, (Object)"code");
                if (code != null && code == 200) continue;
                throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5931\u8d25!");
            }
            catch (Exception e) {
                throw new BusinessException("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5931\u8d25!");
            }
        }
    }

    @Generated
    public GmcCommodityService(AssemblyProp assemblyProp) {
        this.assemblyProp = assemblyProp;
    }
}

