/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.application.IamCreateApplicationRequest;
import com.digiwin.athena.dto.assembly.application.IamCreateApplicationResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class IamApplicationService {
    private final AssemblyProp assemblyProp;

    public List<IamCreateApplicationResponse> createApplication(IamCreateApplicationRequest request, String iamToken) {
        ArrayList<IamCreateApplicationResponse> responseList = new ArrayList<IamCreateApplicationResponse>();
        String url = this.assemblyProp.getIamDomain() + "/api/iam/v2/dev/app";
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).body(BaseConverter.INSTANCE.serialize(request)).header("digi-middleware-auth-user", iamToken)).header("digi-middleware-auth-app", this.assemblyProp.getAppToken())).execute().body();
        Map responseObj = BaseConverter.INSTANCE.deserialize(response, Map.class);
        Boolean success = MapUtil.getBool((Map)responseObj, (Object)"success");
        if (!success.booleanValue()) {
            throw new BusinessException("IAM failed to create the app, error message:" + MapUtil.getStr((Map)responseObj, (Object)"errorMessage"));
        }
        Long appSid = MapUtil.getLong((Map)responseObj, (Object)"data");
        IamCreateApplicationResponse appResponse = new IamCreateApplicationResponse();
        appResponse.setAppSid(appSid);
        AssemblyProp.EnvConfig envConfig = new AssemblyProp.EnvConfig();
        envConfig.setIamDomain(this.assemblyProp.getIamDomain());
        envConfig.setGmcDomain(this.assemblyProp.getGmcDomain());
        appResponse.setEnvConfig(envConfig);
        appResponse.setToken(iamToken);
        responseList.add(appResponse);
        return responseList;
    }

    public String queryAppToken(String appId, String iamToken) {
        Map data;
        Object url = this.assemblyProp.getIamDomain() + "/api/iam/v2/dev/app/one";
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)(url = ((String)url).replace("{id}", appId))).header("digi-middleware-auth-user", iamToken)).header("digi-middleware-auth-app", this.assemblyProp.getAppToken())).execute().body();
        Map responseObj = BaseConverter.INSTANCE.deserialize(response, Map.class);
        Boolean success = MapUtil.getBool((Map)responseObj, (Object)"success");
        if (success.booleanValue() && (data = (Map)responseObj.get("data")) != null) {
            return MapUtil.getStr((Map)data, (Object)"appToken");
        }
        throw new BusinessException("\u67e5\u8be2\u5e94\u7528token\u5931\u8d25");
    }

    public List<IamCreateApplicationResponse> getApplicationInfo(String iamToken) {
        ArrayList<IamCreateApplicationResponse> responseList = new ArrayList<IamCreateApplicationResponse>();
        IamCreateApplicationResponse appResponse = new IamCreateApplicationResponse();
        AssemblyProp.EnvConfig envConfig = new AssemblyProp.EnvConfig();
        envConfig.setIamDomain(this.assemblyProp.getIamDomain());
        envConfig.setGmcDomain(this.assemblyProp.getGmcDomain());
        appResponse.setEnvConfig(envConfig);
        appResponse.setToken(iamToken);
        responseList.add(appResponse);
        return responseList;
    }

    @Generated
    public IamApplicationService(AssemblyProp assemblyProp) {
        this.assemblyProp = assemblyProp;
    }
}

