package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

import java.util.Set;


/**
 * 解决方案配置对象转换器
 */
@Mapper(uses = {BaseConverter.class})
public interface SolutionConvertor {
    SolutionConvertor INSTANCE = Mappers.getMapper(SolutionConvertor.class);

    SolutionPlan toBO(AssemblyApplicationConfigEntity entity);

    @InheritInverseConfiguration
    AssemblyApplicationConfigEntity toEntity(SolutionPlan solution);

    @Mapping(target = "lang", qualifiedByName = "shallowMap")
    SolutionPlanListDTO entityToListDTO(AssemblyApplicationConfigEntity bo);

    Set<SolutionPlanListDTO> entitySetToListDTO(Set<AssemblyApplicationConfigEntity> bo);

    @BeanMapping(unmappedTargetPolicy = ReportingPolicy.IGNORE)
    SolutionPlan toBo(SolutionPlanSaveDTO designer);

    SolutionPlanDetailDTO toDto(SolutionPlan solutionPlan);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void merge(SolutionPlan source, @MappingTarget SolutionPlan target);

    @AfterMapping
    default void translateDetail(@MappingTarget SolutionPlanDetailDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    @AfterMapping
    default void translateList(@MappingTarget SolutionPlanListDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    SolutionPlanBaseDTO toBaseDTO(SolutionPlanListDTO solutionPlan);

    Set<SolutionPlanBaseDTO> toBaseDTO(Set<SolutionPlanListDTO> solutionPlan);

}
