package com.digiwin.athena.dao.mongodao.assetType;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@Slf4j
@Repository
public class DAssetTypeMongoDao {
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public List<AssetType> getAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Query query = buildSearchCondition(pageReqCondition);
        query.limit(pageReqCondition.getPageSize());
        query.skip((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize());

        query.with(Sort.by(Sort.Direction.DESC,"_id"));
        return mongoPrimaryRepositoryDecorator.find(query,AssetType.class);
    }

    private static Query buildSearchCondition(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Criteria criteria = new Criteria();
        AssetTypeListConditionReqDto condition = pageReqCondition.getCondition();
        if (condition!=null){
            List<Criteria> andCondition = new ArrayList<>();
            if(!StringUtils.isEmpty(condition.getCategory())){
                andCondition.add(Criteria.where("category").is(condition.getCategory()));
            }
            if (!StringUtils.isEmpty(condition.getStatus())){
                andCondition.add(Criteria.where("status").is(condition.getStatus()));
            }
            if (!andCondition.isEmpty()){
                criteria.andOperator(andCondition);
            }

            List<Criteria> orCondition = new ArrayList<>();
            if (!StringUtils.isEmpty(condition.getSearchContent())){
                Pattern pattern = Pattern.compile(".*" + Pattern.quote(condition.getSearchContent()) + ".*", Pattern.CASE_INSENSITIVE);

                orCondition.add(Criteria.where("type").regex(pattern));
                orCondition.add(Criteria.where("name").regex(pattern));
            }
            if (!orCondition.isEmpty()){
                criteria.orOperator(orCondition);
            }
        }

        Query query = new Query(criteria);

        return query;
    }

    public Long countAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Query query = buildSearchCondition(pageReqCondition);
        return mongoPrimaryRepositoryDecorator.count(query,AssetType.class);
    }

    public AssetType selectById(String objId) {
        Criteria criteria = Criteria.where("_id").is(objId);
        return mongoPrimaryRepositoryDecorator.findOne(new Query(criteria), AssetType.class);
    }

    public Long checkExistByNameExcludeType(String name, String excludeType) {
        Criteria criteria = Criteria.where("name").is(name).and("type").ne(excludeType);
        Query query = new Query(criteria);
        query.limit(1);
        return mongoPrimaryRepositoryDecorator.count(query, AssetType.class);
    }

    public void save(AssetType assetType) {
        mongoPrimaryRepositoryDecorator.save(assetType);
    }

    public void insert(AssetType assetType) {
        mongoPrimaryRepositoryDecorator.insert(assetType);
    }

    public Long checkExistByType(String type) {
        Criteria criteria = Criteria.where("type").is(type);
        Query query = new Query(criteria);
        query.limit(1);
        return mongoPrimaryRepositoryDecorator.count(query, AssetType.class);
    }

    public void delete(AssetType assetType) {
        mongoPrimaryRepositoryDecorator.delete(assetType);
    }

    public List<AssetType> selectByStatus(List<String> status) {
        Criteria criteria = Criteria.where("status").in(status);
        Query query = new Query(criteria);
        query.fields().exclude("apiList","openApiList","dependencyRule","metadata","dataCollectConfig","manageContextRule");
        return mongoPrimaryRepositoryDecorator.find(query, AssetType.class);
    }
}
