package com.digiwin.athena.dto.assembly.solution;

import cn.hutool.core.date.DatePattern;
import cn.hutool.http.Method;
import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 可组装解决方案配置
 */
@Data
public class SolutionPlanDetailDTO {

    /**
     * 主键ID
     */
    private String id;

    /**
     * 解决方案编码，全局唯一
     */
    @NotBlank
    private String type;

    /**
     * 解决方案名称
     */
    @NotBlank
    private String name;

    /**
     * 版本号，service层暂时写死1.0
     */
    private String version;

    /**
     * 描述
     */
    private String description;

    /**
     * 组装方式：dynamic(可组装)/static(不可组装)
     * @see AssemblyType#getCode()
     */
    private String assemblyType;

    /**
     * 解决方案状态：Draft(草稿)/Online(已上架)/Offline(未上架)
     * @see OnlineState#getCode()
     */
    private String status;

    /**
     * 归属方
     */
    private String owner;

    /**
     * 关联设计器列表
     */
    private List<DesignerBaseInfoDTO> designerList;

    /**
     * 布局配置
     */
    private Map<String, Object> canvas;

    /**
     * 布局方式
     */
    private String layoutMode;

    /**
     * SSO配置(不可组装页面配置)
     */
    private SsoConfigDTO ssoConfig;

    /**
     * 扩展配置字段 - 应用创建回调
     */
    private List<AppCallBackDTO> appCreateCallback;

    /**
     * 扩展配置字段 - 应用更新回调
     */
    private List<AppCallBackDTO> appUpdateCallback;

    /**
     * 扩展配置字段 - 编译回调
     */
    private List<AppCallBackDTO> compile;

    /**
     * 扩展配置字段 - 发布回调
     */
    private List<AppCallBackDTO> publish;

    /**
     * true走标准发布，对应的应用类型会在运维中心体现
     */
    private Boolean isStdPublish;

    /**
     * 多语言配置
     */
    private Map<String, MultiLanguageDTO<String>> lang;

    /**
     * 发布时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private LocalDateTime publishTime;

    /**
     * 发布人
     */
    private String publishBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private LocalDateTime editTime;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 更新人
     */
    private String editBy;

    /**
     * 设计器基础信息DTO
     */
    @Data
    public static class DesignerBaseInfoDTO {

        /**
         * ID
         */
        private String id;

        /**
         * 编码
         */
        private String type;

        /**
         * 名称
         */
        private String name;

        /**
         * 多语言配置
         */
        private Map<String, MultiLanguageDTO<String>> lang;
    }

    /**
     * SSO配置DTO
     */
    @Data
    public static class SsoConfigDTO {

        /**
         * url
         */
        private String url;

        /**
         * 配置信息
         */
        private List<Map<String, Object>> params;
    }

    /**
     * 应用回调DTO
     */
    @Data
    public static class AppCallBackDTO {

        /**
         * api类型，例如：http，groovy
         */
        private String type;

        /**
         * url
         */
        private String url;

        /**
         * 当type是bean时，name是bean的name
         */
        private String name;

        /**
         * 请求类型：GET/POST
         */
        private Method method;

        /**
         * 头信息，json 字符串 k-v 格式
         */
        private String header;

        /**
         * groovy脚本Id
         */
        private String scriptId;

        /**
         * 请求脚本
         */
        private String requestScript;

        /**
         * 响应脚本
         */
        private String responseScript;

        /**
         * 请求方法名称
         */
        private String methodName;
    }
}
