package com.digiwin.athena.mongodb.domain.application;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 资产定义
 */
@Data
@Document(collection = "asset")
public class Asset {

    //草稿draft、effect-生效
    public static final String ADP_STATUS_DRAFT = "draft";
    public static final String ADP_STATUS_EFFECT = "effect";

    @Id
    private String objectId;
    // 资产唯一标识
    private String assetId;
    // 资产类型
    private String type;
    // 业务标识，由各个设计器创建资产时填写, 非唯一
    private String code;

    // 具体资产内容，可根据配置进行检索，如："task":[{"code" : "start_PM_f468894210000dc4"}]
    private Map<String, List<Map<String,Object>>> content;

    /**
     *  资产来源|SD-独立资产，CB-组合资产
     */
    private String source;

    /**
     * 业务数据
     */
    private String businessData;

    private String createBy;
    private String editBy;
    private Date createDate;
    private Date editDate;

    private String assetName;

    private ManageContext manageContext = new ManageContext();
    private ShowField showFields = new ShowField();
    private Map<String, MultiLanguageDTO> lang = new HashMap<>();

    @Deprecated
    private String adpRemark;
    /**
     * 状态|draft-草稿，effect-生效
     */
    @Deprecated
    private String adpStatus;
    @Deprecated
    private String sourceBranch;
    // 所属应用，非必填
    @Deprecated
    private String application;

    /**
     * 版本号,没有多版本，默认就是0
     */
    @Deprecated
    private String adpVersion="0";

    /**
     * 备注序列号
     */
    @Deprecated
    private Integer adpRemarkNumber;

    public static class ManageContext extends JSONObject {
        private String application;
        private String branch;

        private String adpVersion;
        private String adpStatus;

        public String getApplication() {
            return this.getString("application");
        }

        public void setApplication(String application) {
            this.put("application",application);
            this.application = application;
        }

        public String getBranch() {
                return this.getString("branch");
        }

        public void setBranch(String branch) {
            this.put("branch",branch);
            this.branch = branch;
        }

        public String getAdpVersion() {
                return this.getString("adpVersion");
        }

        public void setAdpVersion(String adpVersion) {
            this.put("adpVersion",adpVersion);
            this.adpVersion = adpVersion;
        }

        public String getAdpStatus() {
            return this.getString("adpStatus");
        }

        public void setAdpStatus(String adpStatus) {
            this.put("adpStatus",adpStatus);
            this.adpStatus = adpStatus;
        }
    }

    @Data
    public static class ShowField{
        private String adpRemark;
        private Integer adpRemarkNumber;
        private String versionDescription;
    }
}
