package com.digiwin.athena.service;

import com.digiwin.athena.event.AssetTypeEvent;
import com.digiwin.athena.event.EventOperation;
import com.digiwin.athena.mongodb.domain.PublishAble;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.utils.user.UserHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

public abstract class SyncRuntime<T extends PublishAble> {


    /**
     * 发布
     * @param objId
     */
    public T publish(String objId)  {
        T designerTimeData = getDesignerTimeData(objId);
        Assert.notNull(designerTimeData,"未查询到对应的发布数据");

        T runTimeData = getRunTimeData(objId);
        if (runTimeData!=null){
            deleteRuntimeData(objId);
        }

        designerTimeData.setStatus(AssetType.STATUS_ONLINE);
        designerTimeData.setPublishTime(new Date());

        UserHelper.fillEditInfo(designerTimeData);

        insertRunTimeData(designerTimeData);
        saveDesignerTimeData(designerTimeData);

        return designerTimeData;
    }

    /**
     * 下架
     * @param objId
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    public  T takeDown(String objId)  {
        T designerTimeData = getDesignerTimeData(objId);
        Assert.notNull(designerTimeData,"未查询到对应的数据");

        Assert.notNull(designerTimeData.getPublishTime(),"未发布无法下架");

        T runTimeData = getRunTimeData(objId);
        if (runTimeData!=null){
            runTimeData.setStatus(AssetType.STATUS_OFFLINE);

            UserHelper.fillEditInfo(runTimeData);
            saveRunTimeData(runTimeData);
        }

        designerTimeData.setStatus(AssetType.STATUS_OFFLINE);
        UserHelper.fillEditInfo(designerTimeData);

        saveDesignerTimeData(designerTimeData);
        return designerTimeData;
    }

    /**
     * 上架
     * @param objId
     */
    public T launch(String objId)  {
        T designerTimeData = getDesignerTimeData(objId);
        Assert.notNull(designerTimeData,"未查询到对应的数据");

        Assert.notNull(designerTimeData.getPublishTime(),"未发布无法上架");

        T runTimeData = getRunTimeData(objId);
        if (runTimeData!=null){
            runTimeData.setStatus(AssetType.STATUS_ONLINE);

            UserHelper.fillEditInfo(runTimeData);
            saveRunTimeData(runTimeData);
        }

        designerTimeData.setStatus(AssetType.STATUS_ONLINE);
        UserHelper.fillEditInfo(designerTimeData);

        saveDesignerTimeData(designerTimeData);
        return designerTimeData;
    }

    /**
     * 保存设计时数据
     * @param syncData
     */
    protected abstract void saveDesignerTimeData(T syncData);



    /**
     * 新增运行时数据
     * @param syncData
     */
    protected abstract void insertRunTimeData(T syncData);

    /**
     * 保存运行时数据
     * @param syncData
     */
    protected abstract void saveRunTimeData(T syncData);


    /**
     * 获取要同步的数据
     * @return
     */
    protected abstract T getDesignerTimeData(String objId);

    /**
     * 获取要已经同步运行时的数据
     * @return
     */
    protected  abstract T getRunTimeData(String objId);

    /**
     * 删除运行时数据
     * @param objId
     */
    protected abstract void deleteRuntimeData(String objId);


}
