package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.Asset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-11-25T19:03:22+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 17.0.16 (Eclipse Adoptium)"
)
public class AssetConverterImpl implements AssetConverter {

    private final BaseConverter baseConverter = Mappers.getMapper( BaseConverter.class );

    @Override
    public void merge(Asset source, Asset target) {
        if ( source == null ) {
            return;
        }

        if ( source.getObjectId() != null ) {
            target.setObjectId( source.getObjectId() );
        }
        if ( source.getAssetId() != null ) {
            target.setAssetId( source.getAssetId() );
        }
        if ( source.getType() != null ) {
            target.setType( source.getType() );
        }
        if ( source.getCode() != null ) {
            target.setCode( source.getCode() );
        }
        if ( target.getContent() != null ) {
            Map<String, List<Map<String, Object>>> map = source.getContent();
            if ( map != null ) {
                target.getContent().clear();
                target.getContent().putAll( map );
            }
        }
        else {
            Map<String, List<Map<String, Object>>> map = source.getContent();
            if ( map != null ) {
                target.setContent( new LinkedHashMap<String, List<Map<String, Object>>>( map ) );
            }
        }
        if ( source.getSource() != null ) {
            target.setSource( source.getSource() );
        }
        if ( source.getBusinessData() != null ) {
            target.setBusinessData( source.getBusinessData() );
        }
        if ( source.getCreateBy() != null ) {
            target.setCreateBy( source.getCreateBy() );
        }
        if ( source.getEditBy() != null ) {
            target.setEditBy( source.getEditBy() );
        }
        if ( source.getCreateDate() != null ) {
            target.setCreateDate( source.getCreateDate() );
        }
        if ( source.getEditDate() != null ) {
            target.setEditDate( source.getEditDate() );
        }
        if ( source.getAssetName() != null ) {
            target.setAssetName( source.getAssetName() );
        }
        if ( target.getManageContext() != null ) {
            Asset.ManageContext manageContext = source.getManageContext();
            if ( manageContext != null ) {
                target.getManageContext().clear();
                target.getManageContext().putAll( manageContext );
            }
        }
        else {
            Asset.ManageContext manageContext = source.getManageContext();
            if ( manageContext != null ) {
                target.setManageContext( new Asset.ManageContext( manageContext ) );
            }
        }
        if ( source.getShowFields() != null ) {
            target.setShowFields( source.getShowFields() );
        }
        if ( target.getLang() != null ) {
            Map<String, MultiLanguageDTO> map1 = source.getLang();
            if ( map1 != null ) {
                target.getLang().clear();
                target.getLang().putAll( map1 );
            }
        }
        else {
            Map<String, MultiLanguageDTO> map1 = source.getLang();
            if ( map1 != null ) {
                target.setLang( new LinkedHashMap<String, MultiLanguageDTO>( map1 ) );
            }
        }
        if ( source.getAdpRemark() != null ) {
            target.setAdpRemark( source.getAdpRemark() );
        }
        if ( source.getAdpStatus() != null ) {
            target.setAdpStatus( source.getAdpStatus() );
        }
        if ( source.getSourceBranch() != null ) {
            target.setSourceBranch( source.getSourceBranch() );
        }
        if ( source.getApplication() != null ) {
            target.setApplication( source.getApplication() );
        }
        if ( source.getAdpVersion() != null ) {
            target.setAdpVersion( source.getAdpVersion() );
        }
        if ( source.getAdpRemarkNumber() != null ) {
            target.setAdpRemarkNumber( source.getAdpRemarkNumber() );
        }
    }

    @Override
    public Asset toAsset(AssetCollectApiResponse.AssetData item) {
        if ( item == null ) {
            return null;
        }

        Asset asset = new Asset();

        asset.setType( item.getType() );
        asset.setCode( item.getCode() );
        asset.setBusinessData( item.getBusinessData() );
        asset.setEditDate( baseConverter.localDateTime2Date( item.getEditDate() ) );
        asset.setAssetName( item.getAssetName() );
        Asset.ManageContext manageContext = item.getManageContext();
        if ( manageContext != null ) {
            asset.setManageContext( new Asset.ManageContext( manageContext ) );
        }

        return asset;
    }
}
