package com.digiwin.athena.dto.assetType;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AssetTypeReqDto {

    private String objId;

    @Schema(description = "资产类型")
    private String type;
    @Schema(description = "资产名称")
    private String name;
    @Schema(description = "资产版本")
    private String version;
    @Schema(description = "资产大类")
    private String category;
    @Schema(description = "资产归属")
    private String owner;
    @Schema(description = "状态|草稿draft、已上架online、已下架offline")
    private String status= AssetType.STATUS_DRAFT;
    @Schema(description = "描述")
    private String description;
    @Schema(description = "用户手册")
    private String docUrl;
    @Schema(description = "资产操作api")
    private List<ApiInfo> apiList;
    @Schema(description = "OpenApi")
    private List<ApiInfo> openApiList;

    @Schema(description = "元数据信息")
    private JSONObject metadata;
    @Schema(description = "依赖定义")
    private List<JSONObject> dependencyRule;
    @Schema(description = "管理上下文定义")
    private List<JSONObject> manageContextRule;
    @Schema(description = "数据收集配置")
    private DataCollectConfig dataCollectConfig;
    private JSONObject rowDataPermission;
    private Map<String, MultiLanguageDTO> lang;

    private String icon;

    /**
     * 能否引用
     */
    private Boolean canReference = false;
    /**
     * 能否复制
     */
    private Boolean canCopy = false;
}
