/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.asset.impl;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.convertor.assembly.AssetConverter;
import com.digiwin.athena.dao.mongodao.asset.AssetDefinitionMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetMongoDao;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AssetDataCollectServiceImpl
implements AssetDataCollectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataCollectServiceImpl.class);
    public static final String EDIT_USER = "SYSTEM";
    @Autowired
    private AssetMongoDao assetMongoDao;
    @Autowired
    private AssetDefinitionMongoDao assetDefinitionMongoDao;

    @Override
    public int batchUpsertAssets(List<Asset> assets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int batchProcessDataItems(CollectContext context, List<AssetCollectApiResponse.AssetDataItem> dataItems) {
        if (CollectionUtils.isEmpty(dataItems)) {
            return 0;
        }
        HashMap<String, Set<String>> assetIdsByOp = new HashMap<String, Set<String>>();
        HashMap<String, Supplier<AssetDefinition>> definitionSupplierMap = new HashMap<String, Supplier<AssetDefinition>>();
        List<Asset> assets = this.convertToAssets(dataItems, context, assetIdsByOp, definitionSupplierMap);
        return this.batchUpsertAssets(assets, assetIdsByOp, definitionSupplierMap);
    }

    public int batchUpsertAssets(List<Asset> assets, Map<String, Set<String>> assetIdsByOp, Map<String, Supplier<AssetDefinition>> definitionSupplierMap) {
        if (CollectionUtils.isEmpty(assets)) {
            return 0;
        }
        ArrayList<Asset> toInsert = new ArrayList<Asset>();
        ArrayList<Asset> toUpdate = new ArrayList<Asset>();
        ArrayList<String> toDelete = new ArrayList<String>();
        ArrayList<AssetDefinition> toInsertDefinitions = new ArrayList<AssetDefinition>();
        try {
            List<String> assetIds = assets.stream().map(Asset::getAssetId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
            Map<String, Asset> existingAssetMap = this.assetMongoDao.findByAssetIds(assetIds).stream().collect(Collectors.toMap(Asset::getAssetId, asset -> asset, (a, b) -> a));
            Set<String> existingDefinitionAssetIds = this.assetDefinitionMongoDao.selectExistAssetIds(assetIds);
            Set deleteAssetIds = assetIdsByOp.getOrDefault("delete", Collections.emptySet());
            for (Asset asset2 : assets) {
                Asset existingAsset;
                String assetId = asset2.getAssetId();
                if (deleteAssetIds.contains(assetId)) {
                    if (!existingAssetMap.containsKey(assetId)) continue;
                    toDelete.add(assetId);
                    continue;
                }
                if (!existingDefinitionAssetIds.contains(assetId)) {
                    AssetDefinition assetDefinition = definitionSupplierMap.get(assetId).get();
                    this.prepareDefinitionForInsert(assetDefinition);
                    toInsertDefinitions.add(assetDefinition);
                    existingDefinitionAssetIds.add(assetId);
                }
                if ((existingAsset = existingAssetMap.get(assetId)) == null) {
                    this.prepareAssetForInsert(asset2);
                    toInsert.add(asset2);
                    existingAssetMap.put(assetId, asset2);
                    continue;
                }
                if (this.shouldUpdate(asset2, existingAsset)) {
                    this.prepareAssetForUpdate(asset2, existingAsset);
                    toUpdate.add(existingAsset);
                    continue;
                }
                log.debug("\u8d44\u4ea7\u65e0\u9700\u66f4\u65b0: assetId={},existEditTime:{}, editTime:{}", new Object[]{assetId, existingAsset.getEditDate(), asset2.getEditDate()});
            }
            return this.persist(toInsertDefinitions, toInsert, toUpdate, toDelete);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5904\u7406\u8d44\u4ea7\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u5904\u7406\u8d44\u4ea7\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    protected int persist(List<AssetDefinition> toInsertDefinitions, List<Asset> toInsert, List<Asset> toUpdate, List<String> toDelete) {
        int successCount = 0;
        if (CollUtil.isNotEmpty(toInsertDefinitions)) {
            this.assetDefinitionMongoDao.insertAll(toInsertDefinitions);
            log.info("\u6279\u91cf\u63d2\u5165AssetDefinition\u6210\u529f: count={}", (Object)toInsertDefinitions.size());
        }
        if (CollUtil.isNotEmpty(toInsert)) {
            this.assetMongoDao.insertAll(toInsert);
            successCount += toInsert.size();
            log.info("\u6279\u91cf\u63d2\u5165\u8d44\u4ea7\u6210\u529f: count={}", (Object)toInsert.size());
        }
        if (CollUtil.isNotEmpty(toUpdate)) {
            for (Asset asset : toUpdate) {
                this.assetMongoDao.save(asset);
                ++successCount;
            }
            log.info("\u6279\u91cf\u66f4\u65b0\u8d44\u4ea7\u6210\u529f: count={}", (Object)toUpdate.size());
        }
        if (CollUtil.isNotEmpty(toDelete)) {
            for (String assetId : toDelete) {
                this.assetMongoDao.delete(assetId);
                ++successCount;
            }
            log.info("\u6279\u91cf\u5220\u9664\u8d44\u4ea7\u6210\u529f: count={}", (Object)toDelete.size());
        }
        return successCount;
    }

    protected AssetDefinition buildAssetDefinition(AssetCollectApiResponse.AssetData originData, Asset asset) {
        AssetDefinition definition = new AssetDefinition();
        definition.setAssetId(asset.getAssetId());
        definition.setCode(asset.getCode());
        definition.setType(asset.getType());
        definition.setAssetName(asset.getAssetName());
        definition.setSource("SD");
        definition.setStatus(AssetDefinition.AVAILABLE_STATUS);
        definition.setCreateDate(new Date());
        definition.setEditDate(new Date());
        if (StringUtils.hasText((String)originData.getAdpTenantId())) {
            definition.setAdpTenantId(originData.getAdpTenantId());
        }
        if (asset.getManageContext() != null && !asset.getManageContext().isEmpty()) {
            definition.setManageContext(asset.getManageContext());
        }
        log.debug("\u521b\u5efaAssetDefinition: assetId={}, type={}, code={}", new Object[]{asset.getAssetId(), asset.getType(), asset.getCode()});
        return definition;
    }

    protected boolean shouldUpdate(Asset newAsset, Asset existingAsset) {
        if (newAsset.getEditDate() != null && existingAsset.getEditDate() != null) {
            return newAsset.getEditDate().after(existingAsset.getEditDate());
        }
        return true;
    }

    protected void prepareDefinitionForInsert(AssetDefinition assetDefinition) {
        Date now = new Date();
        assetDefinition.setCreateBy(EDIT_USER);
        assetDefinition.setCreateDate(now);
        assetDefinition.setEditBy(EDIT_USER);
        assetDefinition.setEditDate(now);
    }

    protected void prepareAssetForInsert(Asset asset) {
        Date now = new Date();
        if (asset.getCreateDate() == null) {
            asset.setCreateBy(EDIT_USER);
            asset.setCreateDate(now);
        }
        if (asset.getEditDate() == null) {
            asset.setEditBy(EDIT_USER);
            asset.setEditDate(now);
        }
        if (asset.getManageContext() == null) {
            asset.setManageContext(new Asset.ManageContext());
        }
        asset.getManageContext().setAdpStatus("draft");
        asset.setSource("SD");
    }

    protected void prepareAssetForUpdate(Asset newAsset, Asset existingAsset) {
        if (newAsset.getEditDate() == null) {
            newAsset.setEditBy(EDIT_USER);
            newAsset.setEditDate(new Date());
        }
        newAsset.setSource("SD");
        AssetConverter.INSTANCE.merge(newAsset, existingAsset);
    }

    protected String buildAssetId(String type, String code) {
        return type + "_" + code;
    }

    protected List<Asset> convertToAssets(List<AssetCollectApiResponse.AssetDataItem> dataItems, CollectContext context, Map<String, Set<String>> assetIdsByOp, Map<String, Supplier<AssetDefinition>> definitionSupplierMap) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (AssetCollectApiResponse.AssetDataItem item : dataItems) {
            AssetCollectApiResponse.AssetData data = item.getData();
            if (data == null) continue;
            Asset asset = AssetConverter.INSTANCE.toAsset(data);
            String assetId = this.buildAssetId(data.getType(), data.getCode());
            asset.setAssetId(assetId);
            String op = item.obtainOp(context.getOpFromLoopParam(), assetId);
            assetIdsByOp.computeIfAbsent(op.toLowerCase(), k -> new HashSet()).add(assetId);
            if (!definitionSupplierMap.containsKey(assetId)) {
                definitionSupplierMap.put(assetId, () -> this.buildAssetDefinition(data, asset));
            }
            assets.add(asset);
        }
        return assets;
    }
}

