package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 解决方案运行时
 */
@Slf4j
@RestController
@RequestMapping("/assembly/solution/r/")
@RequiredArgsConstructor
public class RSolutionPlanController {

    private final RSolutionPlanService RSolutionPlanService;

    /**
     * 列表
     */
    @PostMapping("/list")
    public ResultDto<Pagination<SolutionPlanListDTO>> list(@RequestBody PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        log.debug("收到分页查询在线状态解决方案列表请求");
        Pagination<SolutionPlanListDTO> result = RSolutionPlanService.list(pageReqCondition);
        return ResultDto.createSuccess(result);
    }
}
