package com.digiwin.athena.dto.asset;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AssetCenterInfoResDto {

    @Schema(description = "资产id")
    private String assetId;
    @Schema(description = "业务code|比如任务code")
    private String code;
    @Schema(description = "资产来源|SD-独立资产，CB-组合资产，BC-业务中台|BC同样属于独立资产")
    private String source;
    @Schema(description = "归属应用")
    private String application;
    @Schema(description = "应用名称")
    private String applicationName;

    @Schema(description = "资产名称")
    private String assetName;
    @Schema(description = "资产描述")
    private String assetDesc;
    @Schema(description = "标签")
    private List<String> tags = new ArrayList<>();
    @Schema(description = "操作人")
    private String createBy;
    @Schema(description = "修改人")
    private String editBy;
    @Schema(description = "创建时间")
    private Date createDate;
    @Schema(description = "编辑时间")
    private Date editDate;
    @Schema(description = "能否引用")
    private Boolean canReference = false;
    @Schema(description = "能否复制")
    private Boolean canCopy = false;
    @Schema(description = "发布方，目前记录租户id")
    private String publisher;
    private String publisherName;
    @Schema(description = "已复制次数")
    private Integer copiedCount = 0;
    @Schema(description = "已引用次数")
    private Integer referencedCount = 0;
    @Schema(description = "当前引用次数")
    private Integer curReferenceCount=0;

    @Schema(description = "0-未上架，1-已上架")
    private Integer status;

    @Schema(description = "是否存在成果")
    private Boolean hasResult=true;
    @Schema(description = "资产类型|DTD")
    private String type;

    @Schema(description = "开发范围|all-全部，tenant-租户，curTenant-当前租户")
    private String openRange;

    private Map<String, MultiLanguageDTO> lang = new HashMap<>();
    @Schema(description = "生效的资产版本")
    private String effectAdpVersion;
    private Integer effectAdpRemarkNumber;

    @Schema(description = "资产最新版本信息")
    private Asset latestVersionAsset;

    public static AssetCenterInfoResDto create(AssetDefinition assetDefinition){
        AssetCenterInfoResDto assetCenterInfoResDto = new AssetCenterInfoResDto();
        BeanUtils.copyProperties(assetDefinition,assetCenterInfoResDto);

        Map<String, MultiLanguageDTO> lang = assetCenterInfoResDto.getLang();
        if (lang == null){
            lang = new HashMap<>();
            assetCenterInfoResDto.setLang(lang);
        }
        MultiLanguageDTO<String> assetNameLang = lang.get("assetName");
        if (assetNameLang == null){
            assetNameLang = new MultiLanguageDTO<>();
            lang.put("assetName",assetNameLang);
        }
        if (!StringUtils.hasLength(assetNameLang.getZh_CN())){
            assetNameLang.setZh_CN(assetDefinition.getAssetName());
            assetNameLang.setZh_TW(assetDefinition.getAssetName());
            assetNameLang.setEn_US(assetDefinition.getAssetName());
        }
        if (assetDefinition.getManageContext()!=null) {
            assetCenterInfoResDto.setApplication(assetDefinition.getManageContext().getApplication());
        }
        return assetCenterInfoResDto;
    }
}
