package com.digiwin.athena.service.asset;

import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.mongodb.domain.application.Asset;

import java.util.List;

/**
 * 资产数据采集服务接口
 */
public interface AssetDataCollectService {

    /**
     * 批量保存或更新资产
     * 根据code和editDate判断是否更新
     *
     * @param assets 资产列表
     * @return 成功处理的数量
     */
    int batchUpsertAssets(List<Asset> assets);

    /**
     * 批量处理原始数据项（转换并保存）
     * 将AssetCollectApiResponse.AssetDataItem转换为Asset对象，然后批量保存
     *
     * @param context 采集上下文
     * @param dataItems 原始数据项列表
     * @return 成功处理的数量
     */
    int batchProcessDataItems(CollectContext context, List<AssetCollectApiResponse.AssetDataItem> dataItems) throws Exception;
}
