/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DSolutionMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.service.SyncRuntime;
import com.digiwin.athena.service.assembly.CommodityService;
import com.digiwin.athena.service.assembly.DSolutionPlanService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DSolutionPlanServiceImpl
extends SyncRuntime<SolutionPlan>
implements DSolutionPlanService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DSolutionPlanServiceImpl.class);
    private final DSolutionMongoDao dSolutionMongoDao;
    private final RSolutionMongoDao rSolutionMongoDao;
    private final CommodityService commodityService;
    private DSolutionPlanServiceImpl proxyThis;

    @Override
    public Pagination<SolutionPlanListDTO> findList(PageReqCondition<SolutionPlanPageQo> pageReqCondition) {
        return this.dSolutionMongoDao.selectPage(pageReqCondition);
    }

    @Override
    public Map<String, Set<SolutionPlanListDTO>> findListByDesignerId(Iterable<String> designerIdColl) {
        return this.dSolutionMongoDao.findListByDesignerId(designerIdColl);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public SolutionPlan save(SolutionPlanSaveDTO designer) {
        SolutionPlan bo = SolutionConvertor.INSTANCE.toBo(designer);
        this.save(bo);
        return bo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void save(SolutionPlan updated) {
        log.info("\u5f00\u59cb\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848: id:{},updatedName:{}", (Object)updated.getId(), (Object)updated.getName());
        updated.validateTypeFormat();
        this.checkUnique(updated);
        String objectId = updated.getId();
        if (objectId != null) {
            SolutionPlan existed = this.findExist(objectId);
            updated.removeUnmodifiable(existed.getStatus());
            SolutionConvertor.INSTANCE.merge(updated, existed);
            updated = existed;
        } else {
            Integer nextAppType = this.dSolutionMongoDao.getNextAppType();
            updated.setAppType(nextAppType);
            updated.prepareNew();
        }
        this.dSolutionMongoDao.save(updated);
        log.info("\u6210\u529f\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848: {}", (Object)updated.getId());
    }

    protected void pureSave(SolutionPlan bo) {
        this.dSolutionMongoDao.save(bo);
    }

    protected void checkUnique(SolutionPlan bo) {
        if (!this.validateUnique(bo.getType(), null, bo.getId())) {
            throw new BusinessException(Integer.valueOf(30000), "\u7c7b\u578b\u5df2\u5b58\u5728\uff01");
        }
        if (!this.validateUnique(null, bo.getName(), bo.getId())) {
            throw new BusinessException(Integer.valueOf(30000), "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
    }

    protected SolutionPlan findExist(String objectId) {
        return Optional.ofNullable(this.dSolutionMongoDao.selectById(objectId)).orElseThrow(() -> new BusinessException(Integer.valueOf(30201), "\u89e3\u51b3\u65b9\u6848\u4e0d\u5b58\u5728\uff01"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(String objectId) {
        log.info("\u5f00\u59cb\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848: {}", (Object)objectId);
        SolutionPlan bo = this.findExist(objectId);
        bo.checkDelete(bo);
        this.dSolutionMongoDao.deleteById(objectId);
        log.info("\u6210\u529f\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848: {}", (Object)objectId);
    }

    @Override
    public SolutionPlan publish(String objId) {
        SolutionPlan solutionPlan = this.proxyThis.findById(objId);
        boolean firstPublish = solutionPlan.isFirstPublish();
        solutionPlan = super.publish(objId, solutionPlan);
        this.commodityService.syncSolutionPlan(firstPublish, solutionPlan);
        return solutionPlan;
    }

    @Override
    public SolutionPlanDetailDTO findDetailById(String objectId) {
        return SolutionConvertor.INSTANCE.toDto(this.findById(objectId));
    }

    @Override
    public SolutionPlan findById(String objectId) {
        log.debug("\u67e5\u8be2\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848\u8be6\u60c5: {}", (Object)objectId);
        return this.dSolutionMongoDao.selectById(objectId);
    }

    @Override
    public boolean validateUnique(String code, String name, String excludeObjectId) {
        return !this.dSolutionMongoDao.existsByKey(code, name, excludeObjectId);
    }

    @Override
    protected void saveDesignerTimeData(SolutionPlan syncData) {
        this.pureSave(syncData);
    }

    @Override
    protected void insertRunTimeData(SolutionPlan syncData) {
        this.rSolutionMongoDao.save(syncData);
    }

    @Override
    protected void saveRunTimeData(SolutionPlan syncData) {
        this.rSolutionMongoDao.save(syncData);
    }

    @Override
    protected SolutionPlan getDesignerTimeData(String objId) {
        return this.proxyThis.findById(objId);
    }

    @Override
    protected SolutionPlan getRunTimeData(String objId) {
        return this.rSolutionMongoDao.selectById(objId);
    }

    @Override
    protected void deleteRuntimeData(String objId) {
        this.rSolutionMongoDao.deleteById(objId);
    }

    @Autowired
    @Lazy
    public void setProxyThis(DSolutionPlanServiceImpl proxyThis) {
        this.proxyThis = proxyThis;
    }

    @Generated
    public DSolutionPlanServiceImpl(DSolutionMongoDao dSolutionMongoDao, RSolutionMongoDao rSolutionMongoDao, CommodityService commodityService) {
        this.dSolutionMongoDao = dSolutionMongoDao;
        this.rSolutionMongoDao = rSolutionMongoDao;
        this.commodityService = commodityService;
    }
}

