package com.digiwin.athena.controller.assetType;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.base.ErrorCodeConstants;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeListResDto;
import com.digiwin.athena.dto.assetType.AssetTypeReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assetType.DAssetTypeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/assetType/d")
@Tag(name = "设计时资产类型接口",description = "b9903644-f7af-4c02-a28c-989cf8929249")
@Validated
public class DAssetTypeController {

    @Autowired
    private DAssetTypeService dAssetTypeService;
    @Autowired
    private ManageBackgroundUserService manageBackgroundUserService;

    @PostMapping("/getAssetTypeList")
    public ResultDto<Pagination<AssetTypeListResDto>> getAssetTypeList(@RequestBody PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }
        Pagination<AssetTypeListResDto> res = dAssetTypeService.getAssetTypeList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping("/registerAssetType")
    @Operation(summary = "保存资产类型")
    public ResultDto<AssetTypeResDto> registerAssetType(@RequestBody @Validated AssetTypeReqDto assetTypeReqDto){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }
        AssetTypeResDto res = dAssetTypeService.registerAssetType(assetTypeReqDto);
        return ResultDto.createSuccess(res);
    }

    @GetMapping("/getAssetTypeDetail")
    @Operation(summary = "获取资产类型详情")
    public ResultDto<AssetTypeResDto> getAssetTypeDetail(@NotEmpty(message = "id 不能为空") String objId){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }
        AssetTypeResDto res = dAssetTypeService.getAssetTypeDetail(objId);
        return ResultDto.createSuccess(res);
    }

    @GetMapping("/publish")
    public ResultDto<Boolean> publish(@NotEmpty(message = "id 不能为空") String objId){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }
        dAssetTypeService.assetTypePublish(objId);
        return ResultDto.createSuccess(true);
    }

    @GetMapping("/takeDown")
    @Operation(summary = "下架")
    public ResultDto<Boolean> takeDown(@NotEmpty(message = "id 不能为空") String objId){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }

        dAssetTypeService.assetTypeTakeDown(objId);
        return ResultDto.createSuccess(true);
    }

    @GetMapping("/launch")
    @Operation(summary = "上架")
    public ResultDto<Boolean> launch(@NotEmpty(message = "id 不能为空") String objId){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }

        dAssetTypeService.assetTypeLaunch(objId);
        return ResultDto.createSuccess(true);
    }

    @GetMapping("/delete")
    @Operation(summary = "删除")
    public ResultDto<Boolean> delete(@NotEmpty String objId){
        if (!manageBackgroundUserService.isManager()){
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION,new Object[]{});
        }
        dAssetTypeService.delete(objId);
        return ResultDto.createSuccess(true);
    }

    @GetMapping("/getPublishedList")
    @Operation(summary = "获取已发布的列表")
    public ResultDto<List<AssetTypeResDto>> getPublishedList(){

        List<AssetTypeResDto> res = dAssetTypeService.getPublishedList();
        return ResultDto.createSuccess(res);
    }

}
