package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 运行时SolutionPlan列表服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RSolutionPlanServiceImpl implements RSolutionPlanService {

    private final RSolutionMongoDao rSolutionMongoDao;

    @Override
    public Pagination<SolutionPlanListDTO> list(PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        log.debug("分页查询在线状态的解决方案列表");
        // TODO pzz 查询运行时设计器最新名称及type
        return rSolutionMongoDao.selectOnlineSolutionPage(pageReqCondition);
    }
}
