/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.asset;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.businessData.BusinessDataDto;
import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class AssetInfoDto {
    public static final String SD_SOURCE = "SD";
    public static final String CB_SOURCE = "CB";
    private String code;
    private Map metadata;
    private Map<String, List<Map<String, Object>>> content;
    private String application;
    private String adpVersion = "0";
    private String adpTenantId;
    private String assetName;
    private String source;
    private String sourceBranch = "develop";
    private String adpStatus;
    private BusinessDataDto businessData;
    private Integer adpRemarkNumber;
    private Map<String, MultiLanguageDTO> lang;

    public Boolean judgeSaveRequiredFields() {
        return StringUtils.isNotEmpty((CharSequence)this.code) && StringUtils.isNotEmpty((CharSequence)this.application) && StringUtils.isNotEmpty((CharSequence)this.adpVersion) && StringUtils.isNotEmpty((CharSequence)this.adpTenantId) && StringUtils.isNotEmpty((CharSequence)this.source) && StringUtils.isNotEmpty((CharSequence)this.sourceBranch) && StringUtils.isNotEmpty((CharSequence)this.adpStatus);
    }

    public Boolean judgeDeleteRequiredFields() {
        return StringUtils.isNotEmpty((CharSequence)this.code) && StringUtils.isNotEmpty((CharSequence)this.application) && StringUtils.isNotEmpty((CharSequence)this.sourceBranch) && StringUtils.isNotEmpty((CharSequence)this.adpStatus);
    }

    public VersionStatusEnum assetAdpStatus() {
        if ("0".equals(this.adpVersion) && "develop".equals(this.sourceBranch)) {
            return VersionStatusEnum.RUN_STATE;
        }
        if ("develop".equals(this.sourceBranch) && VersionStatusEnum.RUN_STATE.getCode().equals(this.getAdpStatus())) {
            return VersionStatusEnum.RUN_STATE;
        }
        return VersionStatusEnum.DESIGN_STATE;
    }

    public AssetDefinition convertAssetDefinition() {
        AssetDefinition assetDefinition = new AssetDefinition();
        assetDefinition.setAssetName(StringUtils.isNotEmpty((CharSequence)this.assetName) ? this.assetName : this.code);
        assetDefinition.setCode(this.code);
        assetDefinition.setSource(this.source);
        assetDefinition.setLang(this.lang);
        assetDefinition.setAdpTenantId(this.adpTenantId);
        assetDefinition.getManageContext().setApplication(this.application);
        return assetDefinition;
    }

    public Asset convertAsset() {
        Asset asset = new Asset();
        BeanUtils.copyProperties((Object)this, (Object)asset, (String[])new String[]{"businessData"});
        if (this.businessData != null) {
            asset.setBusinessData(JSONObject.toJSONString((Object)this.businessData));
        }
        Asset.ManageContext manageContext = asset.getManageContext();
        manageContext.setAdpStatus(this.assetAdpStatus().getCode());
        manageContext.setApplication(this.application);
        manageContext.setBranch(this.sourceBranch);
        manageContext.setAdpVersion(this.adpVersion);
        Asset.ShowField showFields = asset.getShowFields();
        showFields.setAdpRemarkNumber(this.adpRemarkNumber);
        return asset;
    }

    public static AssetInfoDto create(Asset asset) {
        AssetInfoDto assetInfoDto = new AssetInfoDto();
        BeanUtils.copyProperties((Object)asset, (Object)assetInfoDto);
        Asset.ManageContext manageContext = asset.getManageContext();
        assetInfoDto.setApplication(manageContext.getApplication());
        assetInfoDto.setSourceBranch(manageContext.getBranch());
        assetInfoDto.setAdpVersion(manageContext.getAdpVersion());
        assetInfoDto.setAdpStatus(manageContext.getAdpStatus());
        Asset.ShowField showFields = asset.getShowFields();
        assetInfoDto.setAdpRemarkNumber(showFields.getAdpRemarkNumber());
        return assetInfoDto;
    }

    @Generated
    public AssetInfoDto() {
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Map getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, List<Map<String, Object>>> getContent() {
        return this.content;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getAdpVersion() {
        return this.adpVersion;
    }

    @Generated
    public String getAdpTenantId() {
        return this.adpTenantId;
    }

    @Generated
    public String getAssetName() {
        return this.assetName;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getSourceBranch() {
        return this.sourceBranch;
    }

    @Generated
    public String getAdpStatus() {
        return this.adpStatus;
    }

    @Generated
    public BusinessDataDto getBusinessData() {
        return this.businessData;
    }

    @Generated
    public Integer getAdpRemarkNumber() {
        return this.adpRemarkNumber;
    }

    @Generated
    public Map<String, MultiLanguageDTO> getLang() {
        return this.lang;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setMetadata(Map metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setContent(Map<String, List<Map<String, Object>>> content) {
        this.content = content;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setAdpVersion(String adpVersion) {
        this.adpVersion = adpVersion;
    }

    @Generated
    public void setAdpTenantId(String adpTenantId) {
        this.adpTenantId = adpTenantId;
    }

    @Generated
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    @Generated
    public void setAdpStatus(String adpStatus) {
        this.adpStatus = adpStatus;
    }

    @Generated
    public void setBusinessData(BusinessDataDto businessData) {
        this.businessData = businessData;
    }

    @Generated
    public void setAdpRemarkNumber(Integer adpRemarkNumber) {
        this.adpRemarkNumber = adpRemarkNumber;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO> lang) {
        this.lang = lang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetInfoDto)) {
            return false;
        }
        AssetInfoDto other = (AssetInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$adpRemarkNumber = this.getAdpRemarkNumber();
        Integer other$adpRemarkNumber = other.getAdpRemarkNumber();
        if (this$adpRemarkNumber == null ? other$adpRemarkNumber != null : !((Object)this$adpRemarkNumber).equals(other$adpRemarkNumber)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Map this$metadata = this.getMetadata();
        Map other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, List<Map<String, Object>>> this$content = this.getContent();
        Map<String, List<Map<String, Object>>> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$adpVersion = this.getAdpVersion();
        String other$adpVersion = other.getAdpVersion();
        if (this$adpVersion == null ? other$adpVersion != null : !this$adpVersion.equals(other$adpVersion)) {
            return false;
        }
        String this$adpTenantId = this.getAdpTenantId();
        String other$adpTenantId = other.getAdpTenantId();
        if (this$adpTenantId == null ? other$adpTenantId != null : !this$adpTenantId.equals(other$adpTenantId)) {
            return false;
        }
        String this$assetName = this.getAssetName();
        String other$assetName = other.getAssetName();
        if (this$assetName == null ? other$assetName != null : !this$assetName.equals(other$assetName)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$sourceBranch = this.getSourceBranch();
        String other$sourceBranch = other.getSourceBranch();
        if (this$sourceBranch == null ? other$sourceBranch != null : !this$sourceBranch.equals(other$sourceBranch)) {
            return false;
        }
        String this$adpStatus = this.getAdpStatus();
        String other$adpStatus = other.getAdpStatus();
        if (this$adpStatus == null ? other$adpStatus != null : !this$adpStatus.equals(other$adpStatus)) {
            return false;
        }
        BusinessDataDto this$businessData = this.getBusinessData();
        BusinessDataDto other$businessData = other.getBusinessData();
        if (this$businessData == null ? other$businessData != null : !this$businessData.equals(other$businessData)) {
            return false;
        }
        Map<String, MultiLanguageDTO> this$lang = this.getLang();
        Map<String, MultiLanguageDTO> other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetInfoDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $adpRemarkNumber = this.getAdpRemarkNumber();
        result = result * 59 + ($adpRemarkNumber == null ? 43 : ((Object)$adpRemarkNumber).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Map $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, List<Map<String, Object>>> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $adpVersion = this.getAdpVersion();
        result = result * 59 + ($adpVersion == null ? 43 : $adpVersion.hashCode());
        String $adpTenantId = this.getAdpTenantId();
        result = result * 59 + ($adpTenantId == null ? 43 : $adpTenantId.hashCode());
        String $assetName = this.getAssetName();
        result = result * 59 + ($assetName == null ? 43 : $assetName.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $sourceBranch = this.getSourceBranch();
        result = result * 59 + ($sourceBranch == null ? 43 : $sourceBranch.hashCode());
        String $adpStatus = this.getAdpStatus();
        result = result * 59 + ($adpStatus == null ? 43 : $adpStatus.hashCode());
        BusinessDataDto $businessData = this.getBusinessData();
        result = result * 59 + ($businessData == null ? 43 : $businessData.hashCode());
        Map<String, MultiLanguageDTO> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssetInfoDto(code=" + this.getCode() + ", metadata=" + String.valueOf(this.getMetadata()) + ", content=" + String.valueOf(this.getContent()) + ", application=" + this.getApplication() + ", adpVersion=" + this.getAdpVersion() + ", adpTenantId=" + this.getAdpTenantId() + ", assetName=" + this.getAssetName() + ", source=" + this.getSource() + ", sourceBranch=" + this.getSourceBranch() + ", adpStatus=" + this.getAdpStatus() + ", businessData=" + String.valueOf(this.getBusinessData()) + ", adpRemarkNumber=" + this.getAdpRemarkNumber() + ", lang=" + String.valueOf(this.getLang()) + ")";
    }
}

