package com.digiwin.athena.constants.enums.assembly;

import com.digiwin.athena.constants.enums.BaseLangEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 组装类型枚举
 */
@Getter
@AllArgsConstructor
public enum AssemblyType implements BaseLangEnum<String> {
    /**
     * 可组装
     */
    Dynamic("Dynamic", "可组装", "可組裝", "Dynamic"),
    /**
     * 不可组装
     */
    Static("Static", "不可组装", "不可組裝", "Static");

    private final String code;
    private final String descZhCn;
    private final String descZhTw;
    private final String descEnUs;
}
