package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-11-27T15:30:35+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 17.0.16 (Eclipse Adoptium)"
)
public class SolutionConvertorImpl implements SolutionConvertor {

    private final BaseConverter baseConverter = Mappers.getMapper( BaseConverter.class );

    @Override
    public SolutionPlan toBO(AssemblyApplicationConfigEntity entity) {
        if ( entity == null ) {
            return null;
        }

        SolutionPlan solutionPlan = new SolutionPlan();

        solutionPlan.setId( entity.getId() );
        solutionPlan.setType( entity.getType() );
        solutionPlan.setName( entity.getName() );
        solutionPlan.setVersion( entity.getVersion() );
        solutionPlan.setVersionSort( entity.getVersionSort() );
        solutionPlan.setDescription( entity.getDescription() );
        solutionPlan.setAssemblyType( entity.getAssemblyType() );
        solutionPlan.setStatus( entity.getStatus() );
        solutionPlan.setOwner( entity.getOwner() );
        solutionPlan.setAppType( entity.getAppType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = entity.getDesignerList();
        if ( list != null ) {
            solutionPlan.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = entity.getCanvas();
        if ( map != null ) {
            solutionPlan.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlan.setLayoutMode( entity.getLayoutMode() );
        solutionPlan.setSsoConfig( entity.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = entity.getAppCreateCallback();
        if ( list1 != null ) {
            solutionPlan.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = entity.getAppUpdateCallback();
        if ( list2 != null ) {
            solutionPlan.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = entity.getCompile();
        if ( list3 != null ) {
            solutionPlan.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = entity.getPublish();
        if ( list4 != null ) {
            solutionPlan.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        solutionPlan.setIsStdPublish( entity.getIsStdPublish() );
        Map<String, Object> map1 = entity.getMergeJson();
        if ( map1 != null ) {
            solutionPlan.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = entity.getLang();
        if ( map2 != null ) {
            solutionPlan.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }
        solutionPlan.setPublishTime( baseConverter.localDateTime2Date( entity.getPublishTime() ) );
        solutionPlan.setPublishBy( entity.getPublishBy() );
        solutionPlan.setCreateTime( entity.getCreateTime() );
        solutionPlan.setEditTime( entity.getEditTime() );
        solutionPlan.setCreateBy( entity.getCreateBy() );
        solutionPlan.setEditBy( entity.getEditBy() );

        return solutionPlan;
    }

    @Override
    public AssemblyApplicationConfigEntity toEntity(SolutionPlan solution) {
        if ( solution == null ) {
            return null;
        }

        AssemblyApplicationConfigEntity assemblyApplicationConfigEntity = new AssemblyApplicationConfigEntity();

        assemblyApplicationConfigEntity.setId( solution.getId() );
        assemblyApplicationConfigEntity.setType( solution.getType() );
        assemblyApplicationConfigEntity.setName( solution.getName() );
        assemblyApplicationConfigEntity.setVersion( solution.getVersion() );
        assemblyApplicationConfigEntity.setVersionSort( solution.getVersionSort() );
        assemblyApplicationConfigEntity.setDescription( solution.getDescription() );
        assemblyApplicationConfigEntity.setAssemblyType( solution.getAssemblyType() );
        assemblyApplicationConfigEntity.setStatus( solution.getStatus() );
        assemblyApplicationConfigEntity.setOwner( solution.getOwner() );
        assemblyApplicationConfigEntity.setAppType( solution.getAppType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = solution.getDesignerList();
        if ( list != null ) {
            assemblyApplicationConfigEntity.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = solution.getCanvas();
        if ( map != null ) {
            assemblyApplicationConfigEntity.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        assemblyApplicationConfigEntity.setLayoutMode( solution.getLayoutMode() );
        assemblyApplicationConfigEntity.setSsoConfig( solution.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = solution.getAppCreateCallback();
        if ( list1 != null ) {
            assemblyApplicationConfigEntity.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = solution.getAppUpdateCallback();
        if ( list2 != null ) {
            assemblyApplicationConfigEntity.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = solution.getCompile();
        if ( list3 != null ) {
            assemblyApplicationConfigEntity.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = solution.getPublish();
        if ( list4 != null ) {
            assemblyApplicationConfigEntity.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        assemblyApplicationConfigEntity.setIsStdPublish( solution.getIsStdPublish() );
        Map<String, MultiLanguageDTO<String>> map1 = solution.getLang();
        if ( map1 != null ) {
            assemblyApplicationConfigEntity.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map1 ) );
        }
        Map<String, Object> map2 = solution.getMergeJson();
        if ( map2 != null ) {
            assemblyApplicationConfigEntity.setMergeJson( new LinkedHashMap<String, Object>( map2 ) );
        }
        assemblyApplicationConfigEntity.setPublishTime( baseConverter.date2LocalDateTime( solution.getPublishTime() ) );
        assemblyApplicationConfigEntity.setPublishBy( solution.getPublishBy() );
        assemblyApplicationConfigEntity.setCreateTime( solution.getCreateTime() );
        assemblyApplicationConfigEntity.setEditTime( solution.getEditTime() );
        assemblyApplicationConfigEntity.setCreateBy( solution.getCreateBy() );
        assemblyApplicationConfigEntity.setEditBy( solution.getEditBy() );

        return assemblyApplicationConfigEntity;
    }

    @Override
    public SolutionPlanListDTO entityToListDTO(AssemblyApplicationConfigEntity bo) {
        if ( bo == null ) {
            return null;
        }

        SolutionPlanListDTO solutionPlanListDTO = new SolutionPlanListDTO();

        solutionPlanListDTO.setLang( baseConverter.shallowMap( bo.getLang() ) );
        solutionPlanListDTO.setId( bo.getId() );
        solutionPlanListDTO.setName( bo.getName() );
        solutionPlanListDTO.setType( bo.getType() );
        solutionPlanListDTO.setAssemblyType( bo.getAssemblyType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = bo.getDesignerList();
        if ( list != null ) {
            solutionPlanListDTO.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        solutionPlanListDTO.setOwner( bo.getOwner() );
        solutionPlanListDTO.setStatus( bo.getStatus() );
        solutionPlanListDTO.setVersion( bo.getVersion() );
        solutionPlanListDTO.setIsStdPublish( bo.getIsStdPublish() );
        solutionPlanListDTO.setPublishTime( bo.getPublishTime() );
        solutionPlanListDTO.setPublishBy( bo.getPublishBy() );
        solutionPlanListDTO.setEditTime( bo.getEditTime() );
        solutionPlanListDTO.setEditBy( bo.getEditBy() );

        translateList( solutionPlanListDTO );

        return solutionPlanListDTO;
    }

    @Override
    public Set<SolutionPlanListDTO> entitySetToListDTO(Set<AssemblyApplicationConfigEntity> bo) {
        if ( bo == null ) {
            return null;
        }

        Set<SolutionPlanListDTO> set = new LinkedHashSet<SolutionPlanListDTO>( Math.max( (int) ( bo.size() / .75f ) + 1, 16 ) );
        for ( AssemblyApplicationConfigEntity assemblyApplicationConfigEntity : bo ) {
            set.add( entityToListDTO( assemblyApplicationConfigEntity ) );
        }

        return set;
    }

    @Override
    public SolutionPlan toBo(SolutionPlanSaveDTO designer) {
        if ( designer == null ) {
            return null;
        }

        SolutionPlan solutionPlan = new SolutionPlan();

        solutionPlan.setId( designer.getId() );
        solutionPlan.setType( designer.getType() );
        solutionPlan.setName( designer.getName() );
        solutionPlan.setVersion( designer.getVersion() );
        solutionPlan.setDescription( designer.getDescription() );
        solutionPlan.setAssemblyType( designer.getAssemblyType() );
        solutionPlan.setOwner( designer.getOwner() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = designer.getDesignerList();
        if ( list != null ) {
            solutionPlan.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = designer.getCanvas();
        if ( map != null ) {
            solutionPlan.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlan.setLayoutMode( designer.getLayoutMode() );
        solutionPlan.setSsoConfig( designer.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = designer.getAppCreateCallback();
        if ( list1 != null ) {
            solutionPlan.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = designer.getAppUpdateCallback();
        if ( list2 != null ) {
            solutionPlan.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = designer.getCompile();
        if ( list3 != null ) {
            solutionPlan.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = designer.getPublish();
        if ( list4 != null ) {
            solutionPlan.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        solutionPlan.setIsStdPublish( designer.getIsStdPublish() );
        Map<String, Object> map1 = designer.getMergeJson();
        if ( map1 != null ) {
            solutionPlan.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = designer.getLang();
        if ( map2 != null ) {
            solutionPlan.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }

        return solutionPlan;
    }

    @Override
    public SolutionPlanDetailDTO toDto(SolutionPlan solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        SolutionPlanDetailDTO solutionPlanDetailDTO = new SolutionPlanDetailDTO();

        solutionPlanDetailDTO.setId( solutionPlan.getId() );
        solutionPlanDetailDTO.setType( solutionPlan.getType() );
        solutionPlanDetailDTO.setName( solutionPlan.getName() );
        solutionPlanDetailDTO.setVersion( solutionPlan.getVersion() );
        solutionPlanDetailDTO.setDescription( solutionPlan.getDescription() );
        solutionPlanDetailDTO.setAssemblyType( solutionPlan.getAssemblyType() );
        solutionPlanDetailDTO.setStatus( solutionPlan.getStatus() );
        solutionPlanDetailDTO.setOwner( solutionPlan.getOwner() );
        solutionPlanDetailDTO.setAppType( solutionPlan.getAppType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = solutionPlan.getDesignerList();
        if ( list != null ) {
            solutionPlanDetailDTO.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = solutionPlan.getCanvas();
        if ( map != null ) {
            solutionPlanDetailDTO.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlanDetailDTO.setLayoutMode( solutionPlan.getLayoutMode() );
        solutionPlanDetailDTO.setSsoConfig( solutionPlan.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = solutionPlan.getAppCreateCallback();
        if ( list1 != null ) {
            solutionPlanDetailDTO.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = solutionPlan.getAppUpdateCallback();
        if ( list2 != null ) {
            solutionPlanDetailDTO.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = solutionPlan.getCompile();
        if ( list3 != null ) {
            solutionPlanDetailDTO.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = solutionPlan.getPublish();
        if ( list4 != null ) {
            solutionPlanDetailDTO.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        solutionPlanDetailDTO.setIsStdPublish( solutionPlan.getIsStdPublish() );
        Map<String, Object> map1 = solutionPlan.getMergeJson();
        if ( map1 != null ) {
            solutionPlanDetailDTO.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = solutionPlan.getLang();
        if ( map2 != null ) {
            solutionPlanDetailDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }
        solutionPlanDetailDTO.setPublishTime( baseConverter.date2LocalDateTime( solutionPlan.getPublishTime() ) );
        solutionPlanDetailDTO.setPublishBy( solutionPlan.getPublishBy() );
        solutionPlanDetailDTO.setCreateTime( solutionPlan.getCreateTime() );
        solutionPlanDetailDTO.setEditTime( solutionPlan.getEditTime() );
        solutionPlanDetailDTO.setCreateBy( solutionPlan.getCreateBy() );
        solutionPlanDetailDTO.setEditBy( solutionPlan.getEditBy() );

        translateDetail( solutionPlanDetailDTO );

        return solutionPlanDetailDTO;
    }

    @Override
    public void merge(SolutionPlan source, SolutionPlan target) {
        if ( source == null ) {
            return;
        }

        if ( source.getId() != null ) {
            target.setId( source.getId() );
        }
        if ( source.getType() != null ) {
            target.setType( source.getType() );
        }
        if ( source.getName() != null ) {
            target.setName( source.getName() );
        }
        if ( source.getVersion() != null ) {
            target.setVersion( source.getVersion() );
        }
        if ( source.getVersionSort() != null ) {
            target.setVersionSort( source.getVersionSort() );
        }
        if ( source.getDescription() != null ) {
            target.setDescription( source.getDescription() );
        }
        if ( source.getAssemblyType() != null ) {
            target.setAssemblyType( source.getAssemblyType() );
        }
        if ( source.getStatus() != null ) {
            target.setStatus( source.getStatus() );
        }
        if ( source.getOwner() != null ) {
            target.setOwner( source.getOwner() );
        }
        if ( source.getAppType() != null ) {
            target.setAppType( source.getAppType() );
        }
        if ( target.getDesignerList() != null ) {
            List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = source.getDesignerList();
            if ( list != null ) {
                target.getDesignerList().clear();
                target.getDesignerList().addAll( list );
            }
        }
        else {
            List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = source.getDesignerList();
            if ( list != null ) {
                target.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
            }
        }
        if ( target.getCanvas() != null ) {
            Map<String, Object> map = source.getCanvas();
            if ( map != null ) {
                target.getCanvas().clear();
                target.getCanvas().putAll( map );
            }
        }
        else {
            Map<String, Object> map = source.getCanvas();
            if ( map != null ) {
                target.setCanvas( new LinkedHashMap<String, Object>( map ) );
            }
        }
        if ( source.getLayoutMode() != null ) {
            target.setLayoutMode( source.getLayoutMode() );
        }
        if ( source.getSsoConfig() != null ) {
            target.setSsoConfig( source.getSsoConfig() );
        }
        if ( target.getAppCreateCallback() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = source.getAppCreateCallback();
            if ( list1 != null ) {
                target.getAppCreateCallback().clear();
                target.getAppCreateCallback().addAll( list1 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = source.getAppCreateCallback();
            if ( list1 != null ) {
                target.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
            }
        }
        if ( target.getAppUpdateCallback() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = source.getAppUpdateCallback();
            if ( list2 != null ) {
                target.getAppUpdateCallback().clear();
                target.getAppUpdateCallback().addAll( list2 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = source.getAppUpdateCallback();
            if ( list2 != null ) {
                target.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
            }
        }
        if ( target.getCompile() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = source.getCompile();
            if ( list3 != null ) {
                target.getCompile().clear();
                target.getCompile().addAll( list3 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = source.getCompile();
            if ( list3 != null ) {
                target.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
            }
        }
        if ( target.getPublish() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = source.getPublish();
            if ( list4 != null ) {
                target.getPublish().clear();
                target.getPublish().addAll( list4 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = source.getPublish();
            if ( list4 != null ) {
                target.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
            }
        }
        if ( source.getIsStdPublish() != null ) {
            target.setIsStdPublish( source.getIsStdPublish() );
        }
        if ( target.getMergeJson() != null ) {
            Map<String, Object> map1 = source.getMergeJson();
            if ( map1 != null ) {
                target.getMergeJson().clear();
                target.getMergeJson().putAll( map1 );
            }
        }
        else {
            Map<String, Object> map1 = source.getMergeJson();
            if ( map1 != null ) {
                target.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
            }
        }
        if ( target.getLang() != null ) {
            Map<String, MultiLanguageDTO<String>> map2 = source.getLang();
            if ( map2 != null ) {
                target.getLang().clear();
                target.getLang().putAll( map2 );
            }
        }
        else {
            Map<String, MultiLanguageDTO<String>> map2 = source.getLang();
            if ( map2 != null ) {
                target.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
            }
        }
        if ( source.getPublishTime() != null ) {
            target.setPublishTime( source.getPublishTime() );
        }
        if ( source.getPublishBy() != null ) {
            target.setPublishBy( source.getPublishBy() );
        }
        if ( source.getCreateTime() != null ) {
            target.setCreateTime( source.getCreateTime() );
        }
        if ( source.getEditTime() != null ) {
            target.setEditTime( source.getEditTime() );
        }
        if ( source.getCreateBy() != null ) {
            target.setCreateBy( source.getCreateBy() );
        }
        if ( source.getEditBy() != null ) {
            target.setEditBy( source.getEditBy() );
        }
    }

    @Override
    public SolutionPlanBaseDTO toBaseDTO(SolutionPlanListDTO solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        SolutionPlanBaseDTO solutionPlanBaseDTO = new SolutionPlanBaseDTO();

        solutionPlanBaseDTO.setId( solutionPlan.getId() );
        solutionPlanBaseDTO.setType( solutionPlan.getType() );
        solutionPlanBaseDTO.setName( solutionPlan.getName() );
        Map<String, MultiLanguageDTO<String>> map = solutionPlan.getLang();
        if ( map != null ) {
            solutionPlanBaseDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }

        return solutionPlanBaseDTO;
    }

    @Override
    public Set<SolutionPlanBaseDTO> toBaseDTO(Set<SolutionPlanListDTO> solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        Set<SolutionPlanBaseDTO> set = new LinkedHashSet<SolutionPlanBaseDTO>( Math.max( (int) ( solutionPlan.size() / .75f ) + 1, 16 ) );
        for ( SolutionPlanListDTO solutionPlanListDTO : solutionPlan ) {
            set.add( toBaseDTO( solutionPlanListDTO ) );
        }

        return set;
    }
}
