/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.assetType;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeListResDto;
import com.digiwin.athena.dto.assetType.AssetTypeReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assetType.DAssetTypeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assetType/d"})
@Tag(name="\u8bbe\u8ba1\u65f6\u8d44\u4ea7\u7c7b\u578b\u63a5\u53e3", description="b9903644-f7af-4c02-a28c-989cf8929249")
@Validated
public class DAssetTypeController {
    @Autowired
    private DAssetTypeService dAssetTypeService;
    @Autowired
    private ManageBackgroundUserService manageBackgroundUserService;

    @PostMapping(value={"/getAssetTypeList"})
    public ResultDto<Pagination<AssetTypeListResDto>> getAssetTypeList(@RequestBody PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        Pagination<AssetTypeListResDto> res = this.dAssetTypeService.getAssetTypeList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/registerAssetType"})
    @Operation(summary="\u4fdd\u5b58\u8d44\u4ea7\u7c7b\u578b")
    public ResultDto<AssetTypeResDto> registerAssetType(@RequestBody @Validated AssetTypeReqDto assetTypeReqDto) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        AssetTypeResDto res = this.dAssetTypeService.registerAssetType(assetTypeReqDto);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/getAssetTypeDetail"})
    @Operation(summary="\u83b7\u53d6\u8d44\u4ea7\u7c7b\u578b\u8be6\u60c5")
    public ResultDto<AssetTypeResDto> getAssetTypeDetail(@NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") String objId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        AssetTypeResDto res = this.dAssetTypeService.getAssetTypeDetail(objId);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/publish"})
    public ResultDto<Boolean> publish(@NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") String objId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.dAssetTypeService.assetTypePublish(objId);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/takeDown"})
    @Operation(summary="\u4e0b\u67b6")
    public ResultDto<Boolean> takeDown(@NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") String objId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.dAssetTypeService.assetTypeTakeDown(objId);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/launch"})
    @Operation(summary="\u4e0a\u67b6")
    public ResultDto<Boolean> launch(@NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="id \u4e0d\u80fd\u4e3a\u7a7a") String objId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.dAssetTypeService.assetTypeLaunch(objId);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u5220\u9664")
    public ResultDto<Boolean> delete(@NotEmpty String objId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.dAssetTypeService.delete(objId);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/getPublishedList"})
    @Operation(summary="\u83b7\u53d6\u5df2\u53d1\u5e03\u7684\u5217\u8868")
    public ResultDto<List<AssetTypeResDto>> getPublishedList() {
        List<AssetTypeResDto> res = this.dAssetTypeService.getPublishedList();
        return ResultDto.createSuccess(res);
    }
}

