/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.asset;

import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetPermission;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class AssetDetailResDto
extends AssetCenterInfoResDto {
    @Schema(description="\u53ef\u590d\u5236\u7248\u672c")
    private List<String> copyableItems = new ArrayList<String>();
    @Schema(description="\u6307\u5b9a\u5f00\u53d1\u7684\u79df\u6237id|openRange=tenant\u65f6")
    private List<TenantInfo> tenantInfos = new ArrayList<TenantInfo>();
    private String businessData;
    private Asset.ManageContext manageContext = new Asset.ManageContext();
    private Asset.ShowField showFields = new Asset.ShowField();

    public static AssetDetailResDto create(Asset asset) {
        AssetDetailResDto assetDetailResDto = new AssetDetailResDto();
        BeanUtils.copyProperties((Object)asset, (Object)assetDetailResDto);
        return assetDetailResDto;
    }

    public static AssetDetailResDto create(AssetDefinition assetDefinition) {
        AssetPermission permission;
        Asset.ManageContext manageContext;
        MultiLanguageDTO assetDescLang;
        MultiLanguageDTO assetNameLang;
        AssetDetailResDto assetDetailResDto = new AssetDetailResDto();
        BeanUtils.copyProperties((Object)assetDefinition, (Object)assetDetailResDto);
        Map<String, MultiLanguageDTO> lang = assetDetailResDto.getLang();
        if (lang == null) {
            lang = new HashMap<String, MultiLanguageDTO>();
            assetDetailResDto.setLang(lang);
        }
        if ((assetNameLang = lang.get("assetName")) == null) {
            assetNameLang = new MultiLanguageDTO();
            lang.put("assetName", assetNameLang);
        }
        if (!StringUtils.hasLength((String)((String)assetNameLang.getZh_CN()))) {
            assetNameLang.setZh_CN((Object)assetDefinition.getAssetName());
            assetNameLang.setZh_TW((Object)assetDefinition.getAssetName());
            assetNameLang.setEn_US((Object)assetDefinition.getAssetName());
        }
        if ((assetDescLang = lang.get("assetDesc")) == null) {
            assetDescLang = new MultiLanguageDTO();
            lang.put("assetDesc", assetNameLang);
        }
        if (!StringUtils.hasLength((String)((String)assetDescLang.getZh_CN()))) {
            assetDescLang.setZh_CN((Object)assetDefinition.getAssetDesc());
            assetDescLang.setZh_TW((Object)assetDefinition.getAssetDesc());
            assetDescLang.setEn_US((Object)assetDefinition.getAssetDesc());
        }
        if ((manageContext = assetDefinition.getManageContext()) != null) {
            assetDetailResDto.setApplication(manageContext.getApplication());
        }
        if ((permission = assetDefinition.getPermission()) != null) {
            assetDetailResDto.setTenantInfos(permission.getTenantInfos());
        }
        return assetDetailResDto;
    }

    @Generated
    public AssetDetailResDto() {
    }

    @Generated
    public List<String> getCopyableItems() {
        return this.copyableItems;
    }

    @Generated
    public List<TenantInfo> getTenantInfos() {
        return this.tenantInfos;
    }

    @Generated
    public String getBusinessData() {
        return this.businessData;
    }

    @Generated
    public Asset.ManageContext getManageContext() {
        return this.manageContext;
    }

    @Generated
    public Asset.ShowField getShowFields() {
        return this.showFields;
    }

    @Generated
    public void setCopyableItems(List<String> copyableItems) {
        this.copyableItems = copyableItems;
    }

    @Generated
    public void setTenantInfos(List<TenantInfo> tenantInfos) {
        this.tenantInfos = tenantInfos;
    }

    @Generated
    public void setBusinessData(String businessData) {
        this.businessData = businessData;
    }

    @Generated
    public void setManageContext(Asset.ManageContext manageContext) {
        this.manageContext = manageContext;
    }

    @Generated
    public void setShowFields(Asset.ShowField showFields) {
        this.showFields = showFields;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetDetailResDto)) {
            return false;
        }
        AssetDetailResDto other = (AssetDetailResDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$copyableItems = this.getCopyableItems();
        List<String> other$copyableItems = other.getCopyableItems();
        if (this$copyableItems == null ? other$copyableItems != null : !((Object)this$copyableItems).equals(other$copyableItems)) {
            return false;
        }
        List<TenantInfo> this$tenantInfos = this.getTenantInfos();
        List<TenantInfo> other$tenantInfos = other.getTenantInfos();
        if (this$tenantInfos == null ? other$tenantInfos != null : !((Object)this$tenantInfos).equals(other$tenantInfos)) {
            return false;
        }
        String this$businessData = this.getBusinessData();
        String other$businessData = other.getBusinessData();
        if (this$businessData == null ? other$businessData != null : !this$businessData.equals(other$businessData)) {
            return false;
        }
        Asset.ManageContext this$manageContext = this.getManageContext();
        Asset.ManageContext other$manageContext = other.getManageContext();
        if (this$manageContext == null ? other$manageContext != null : !((Object)this$manageContext).equals(other$manageContext)) {
            return false;
        }
        Asset.ShowField this$showFields = this.getShowFields();
        Asset.ShowField other$showFields = other.getShowFields();
        return !(this$showFields == null ? other$showFields != null : !((Object)this$showFields).equals(other$showFields));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetDetailResDto;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $copyableItems = this.getCopyableItems();
        result = result * 59 + ($copyableItems == null ? 43 : ((Object)$copyableItems).hashCode());
        List<TenantInfo> $tenantInfos = this.getTenantInfos();
        result = result * 59 + ($tenantInfos == null ? 43 : ((Object)$tenantInfos).hashCode());
        String $businessData = this.getBusinessData();
        result = result * 59 + ($businessData == null ? 43 : $businessData.hashCode());
        Asset.ManageContext $manageContext = this.getManageContext();
        result = result * 59 + ($manageContext == null ? 43 : ((Object)$manageContext).hashCode());
        Asset.ShowField $showFields = this.getShowFields();
        result = result * 59 + ($showFields == null ? 43 : ((Object)$showFields).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AssetDetailResDto(copyableItems=" + String.valueOf(this.getCopyableItems()) + ", tenantInfos=" + String.valueOf(this.getTenantInfos()) + ", businessData=" + this.getBusinessData() + ", manageContext=" + String.valueOf(this.getManageContext()) + ", showFields=" + String.valueOf(this.getShowFields()) + ")";
    }
}

