/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assetType.impl;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assetType.DAssetTypeMongoDao;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assetType.AssetTypeBaseDTO;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeListResDto;
import com.digiwin.athena.dto.assetType.AssetTypeReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.dto.assetType.RelationDesignerInfo;
import com.digiwin.athena.event.AssetTypeEvent;
import com.digiwin.athena.event.EventOperation;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.SyncRuntime;
import com.digiwin.athena.service.assetType.DAssetTypeService;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class DAssetTypeServiceImpl
extends SyncRuntime<AssetType>
implements DAssetTypeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DAssetTypeServiceImpl.class);
    @Autowired
    private DAssetTypeMongoDao dAssetTypeMongoDao;
    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private DDesignerMongoDao dDesignerMongoDao;

    @Override
    public Pagination<AssetTypeListResDto> getAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Long count = this.dAssetTypeMongoDao.countAssetTypeList(pageReqCondition);
        List<AssetType> assetTypeList = this.dAssetTypeMongoDao.getAssetTypeList(pageReqCondition);
        List res = assetTypeList.stream().map(r -> AssetTypeListResDto.create(r)).collect(Collectors.toList());
        if (!res.isEmpty()) {
            Map<String, AssetTypeListResDto> resMap = res.stream().collect(Collectors.toMap(AssetTypeListResDto::getObjId, a -> a));
            List<Designer> designers = this.dDesignerMongoDao.selectByRelatedAsset(resMap.keySet());
            for (Designer designer : designers) {
                List<AssetTypeBaseDTO> read;
                DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designer.getRelatedAssetType();
                if (relatedAssetType == null) continue;
                HashMap<String, RelationDesignerInfo> relationDesignerInfoMap = new HashMap<String, RelationDesignerInfo>();
                List<AssetTypeBaseDTO> write = relatedAssetType.getWrite();
                if (!CollectionUtils.isEmpty(write)) {
                    for (AssetTypeBaseDTO assetTypeBaseDTO : write) {
                        if (relationDesignerInfoMap.containsKey(assetTypeBaseDTO.getObjId())) {
                            RelationDesignerInfo relationDesignerInfo = (RelationDesignerInfo)relationDesignerInfoMap.get(assetTypeBaseDTO.getObjId());
                            relationDesignerInfo.setWrite(true);
                            continue;
                        }
                        RelationDesignerInfo relationDesignerInfo = RelationDesignerInfo.create(designer);
                        relationDesignerInfo.setWrite(true);
                        relationDesignerInfoMap.put(assetTypeBaseDTO.getObjId(), relationDesignerInfo);
                    }
                }
                if (!CollectionUtils.isEmpty(read = relatedAssetType.getRead())) {
                    for (AssetTypeBaseDTO assetTypeBaseDTO : read) {
                        RelationDesignerInfo relationDesignerInfo;
                        if (relationDesignerInfoMap.containsKey(assetTypeBaseDTO.getObjId())) {
                            relationDesignerInfo = (RelationDesignerInfo)relationDesignerInfoMap.get(assetTypeBaseDTO.getObjId());
                            relationDesignerInfo.setRead(true);
                            continue;
                        }
                        relationDesignerInfo = RelationDesignerInfo.create(designer);
                        relationDesignerInfo.setRead(true);
                        relationDesignerInfoMap.put(assetTypeBaseDTO.getObjId(), relationDesignerInfo);
                    }
                }
                for (Map.Entry entry : relationDesignerInfoMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!resMap.containsKey(key)) continue;
                    AssetTypeListResDto assetTypeListResDto = resMap.get(key);
                    assetTypeListResDto.getRelationDesignerInfoList().add((RelationDesignerInfo)entry.getValue());
                }
            }
        }
        return Pagination.buildPagination(pageReqCondition, res, (Long)count);
    }

    @Override
    public AssetTypeResDto registerAssetType(AssetTypeReqDto assetTypeReqDto) {
        assetTypeReqDto.validateTypeFormat();
        if (StringUtils.isNotEmpty((CharSequence)assetTypeReqDto.getObjId())) {
            Long count;
            AssetType oldAssetType = this.dAssetTypeMongoDao.selectById(assetTypeReqDto.getObjId());
            Assert.notNull((Object)oldAssetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b");
            if (!assetTypeReqDto.getName().equals(oldAssetType.getName())) {
                count = this.dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(), oldAssetType.getType());
                Assert.isTrue((boolean)count.equals(0L), (String)"\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (!assetTypeReqDto.getType().equals(oldAssetType.getType())) {
                count = this.dAssetTypeMongoDao.checkExistByType(assetTypeReqDto.getType());
                Assert.isTrue((boolean)count.equals(0L), (String)"\u7c7b\u578b\u5df2\u5b58\u5728");
            }
            BeanUtils.copyProperties((Object)assetTypeReqDto, (Object)oldAssetType);
            UserHelper.fillEditInfo((Object)oldAssetType);
            this.dAssetTypeMongoDao.save(oldAssetType);
            return AssetTypeResDto.create(oldAssetType);
        }
        Long count = this.dAssetTypeMongoDao.checkExistByType(assetTypeReqDto.getType());
        Assert.isTrue((boolean)count.equals(0L), (String)"\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728");
        count = this.dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(), assetTypeReqDto.getType());
        Assert.isTrue((boolean)count.equals(0L), (String)"\u540d\u79f0\u5df2\u5b58\u5728");
        AssetType assetType = new AssetType();
        BeanUtils.copyProperties((Object)assetTypeReqDto, (Object)assetType);
        UserHelper.fillCreateInfo((Object)assetType);
        UserHelper.fillEditInfo((Object)assetType);
        this.dAssetTypeMongoDao.insert(assetType);
        return AssetTypeResDto.create(assetType);
    }

    @Override
    public AssetTypeResDto getAssetTypeDetail(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u4fe1\u606f");
        AssetTypeResDto assetTypeResDto = AssetTypeResDto.create(assetType);
        List<Designer> designers = this.dDesignerMongoDao.selectByRelatedAsset(objId);
        List<RelationDesignerInfo> relationDesignerInfos = designers.stream().map(d -> RelationDesignerInfo.create(d)).collect(Collectors.toList());
        assetTypeResDto.setRelationDesignerInfos(relationDesignerInfos);
        return assetTypeResDto;
    }

    @Override
    public void assetTypePublish(String objId) {
        AssetType assetType = (AssetType)this.publish(objId);
        AssetTypeEvent assetTypeEvent = new AssetTypeEvent(assetType, EventOperation.UPDATE);
        this.applicationEventPublisher.publishEvent((Object)assetTypeEvent);
    }

    @Override
    public void assetTypeTakeDown(String objId) {
        AssetType assetType = (AssetType)this.takeDown(objId);
        AssetTypeEvent assetTypeEvent = new AssetTypeEvent(assetType, EventOperation.DELETE);
        this.applicationEventPublisher.publishEvent((Object)assetTypeEvent);
    }

    @Override
    public void assetTypeLaunch(String objId) {
        AssetType assetType = (AssetType)this.launch(objId);
        AssetTypeEvent assetTypeEvent = new AssetTypeEvent(assetType, EventOperation.UPDATE);
        this.applicationEventPublisher.publishEvent((Object)assetTypeEvent);
    }

    @Override
    public void delete(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55");
        Assert.isTrue((boolean)"draft".equals(assetType.getStatus()), (String)"\u975e\u8349\u7a3f\u65e0\u6cd5\u5220\u9664");
        this.dAssetTypeMongoDao.delete(assetType);
    }

    @Override
    public List<AssetTypeResDto> getPublishedList() {
        List<AssetType> assetTypeList = this.dAssetTypeMongoDao.selectByStatus(Arrays.asList("offline", "online"));
        List<AssetTypeResDto> res = assetTypeList.stream().map(a -> AssetTypeResDto.create(a)).collect(Collectors.toList());
        return res;
    }

    @Override
    protected void saveDesignerTimeData(AssetType syncData) {
        this.dAssetTypeMongoDao.save(syncData);
    }

    @Override
    protected void insertRunTimeData(AssetType syncData) {
        this.rAssetTypeMongoDao.insert(syncData);
    }

    @Override
    protected void saveRunTimeData(AssetType syncData) {
        this.rAssetTypeMongoDao.save(syncData);
    }

    @Override
    protected AssetType getDesignerTimeData(String objId) {
        return this.dAssetTypeMongoDao.selectById(objId);
    }

    @Override
    protected AssetType getRunTimeData(String objId) {
        return this.rAssetTypeMongoDao.selectById(objId);
    }

    @Override
    protected void deleteRuntimeData(String objId) {
        this.rAssetTypeMongoDao.deleteById(objId);
    }
}

