/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DDesignerMongoDaoImpl
implements DDesignerMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDesignerMongoDaoImpl.class);
    private static final DesignerConvertor CONVERTOR = DesignerConvertor.INSTANCE;
    private final MongoPrimaryRepositoryDecorator decorator;

    @Override
    public Designer selectById(String objectId) {
        DesignerEntity entity = (DesignerEntity)this.decorator.findById((Object)objectId, DesignerEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public Designer selectByCode(String code) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        DesignerEntity entity = (DesignerEntity)this.decorator.findOne(query, DesignerEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public Designer selectByName(String name) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        DesignerEntity entity = (DesignerEntity)this.decorator.findOne(query, DesignerEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public void save(Designer designer) {
        DesignerEntity entity = CONVERTOR.toPo(designer);
        entity.prepareSave();
        this.decorator.save((Object)entity);
        designer.setId(entity.getId());
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)objectId));
        long count = this.decorator.remove(query, DesignerEntity.class);
        return count > 0L;
    }

    @Override
    public boolean existsByKey(String code, String name, String excludeId) {
        Assert.isFalse((boolean)StrUtil.isAllBlank((CharSequence[])new CharSequence[]{code, name}), (String)"code or name can not be null", (Object[])new Object[0]);
        Query query = new Query();
        if (StrUtil.isNotBlank((CharSequence)code)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        }
        if (excludeId != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").ne((Object)excludeId));
        }
        return this.decorator.count(query, DesignerEntity.class) > 0L;
    }

    @Override
    public Pagination<DesignerListDTO> selectPage(PageReqCondition<DesignerPageQo> pageParam) {
        Query query = new Query();
        this.buildPageCondition(pageParam, query);
        return this.decorator.findWithPage(query, DesignerEntity.class, pageParam).convert(DesignerConvertor.INSTANCE::toListDTO);
    }

    @Override
    public List<Designer> selectByRelatedAsset(String assetTypeId) {
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"relatedAssetType.read.objId").is((Object)assetTypeId), Criteria.where((String)"relatedAssetType.write.objId").is((Object)assetTypeId)});
        return this.decorator.find(new Query((CriteriaDefinition)criteria), DesignerEntity.class).stream().map(CONVERTOR::toBO).collect(Collectors.toList());
    }

    @Override
    public List<Designer> selectByRelatedAsset(Collection<String> assetTypeIds) {
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"relatedAssetType.read.objId").in(assetTypeIds), Criteria.where((String)"relatedAssetType.write.objId").in(assetTypeIds)});
        return this.decorator.find(new Query((CriteriaDefinition)criteria), DesignerEntity.class).stream().map(CONVERTOR::toBO).collect(Collectors.toList());
    }

    protected void buildPageCondition(PageReqCondition<DesignerPageQo> pageParam, Query query) {
        DesignerPageQo condition = (DesignerPageQo)ObjectUtil.defaultIfNull((Object)((DesignerPageQo)pageParam.getCondition()), DesignerPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        if (CollUtil.isNotEmpty(condition.getIntegrationTypeList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"integrationType").in(condition.getIntegrationTypeList()));
        }
        if (CollUtil.isNotEmpty(condition.getStatusList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(condition.getStatusList()));
        }
    }

    @Generated
    public DDesignerMongoDaoImpl(MongoPrimaryRepositoryDecorator decorator) {
        this.decorator = decorator;
    }
}

