/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.DSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;
import com.digiwin.athena.mongodb.domain.assembly.AssemblyApplicationConfigEntity;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DSolutionMongoDaoImpl
implements DSolutionMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DSolutionMongoDaoImpl.class);
    private static final SolutionConvertor CONVERTOR = SolutionConvertor.INSTANCE;
    private final MongoPrimaryRepositoryDecorator decorator;

    @Override
    public SolutionPlan selectById(String objectId) {
        AssemblyApplicationConfigEntity entity = (AssemblyApplicationConfigEntity)this.decorator.findById((Object)objectId, AssemblyApplicationConfigEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public SolutionPlan selectByCode(String code) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        AssemblyApplicationConfigEntity entity = (AssemblyApplicationConfigEntity)this.decorator.findOne(query, AssemblyApplicationConfigEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public SolutionPlan selectByName(String name) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        AssemblyApplicationConfigEntity entity = (AssemblyApplicationConfigEntity)this.decorator.findOne(query, AssemblyApplicationConfigEntity.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public void save(SolutionPlan solution) {
        AssemblyApplicationConfigEntity entity = CONVERTOR.toEntity(solution);
        entity.prepareSave();
        Map<String, Object> mergeJson = solution.getMergeJson();
        if (Boolean.TRUE.equals(solution.getIsStdPublish()) && CollUtil.isNotEmpty(mergeJson)) {
            String collectionName = this.decorator.getCollectionNameFromDocumentAnnotedClass(AssemblyApplicationConfigEntity.class);
            Map<String, Object> entityMap = entity.mergeToEntityMap();
            this.decorator.save(entityMap, collectionName);
            solution.setId(MapUtil.getStr(entityMap, (Object)FieldName.ID.name()));
        } else {
            this.decorator.save((Object)entity);
            solution.setId(entity.getId());
        }
    }

    @Override
    public Integer getNextAppType() {
        Query query = new Query();
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"appType"}));
        query.limit(1);
        AssemblyApplicationConfigEntity maxEntity = (AssemblyApplicationConfigEntity)this.decorator.findOne(query, AssemblyApplicationConfigEntity.class);
        if (maxEntity == null || maxEntity.getAppType() == null) {
            return 1;
        }
        return maxEntity.getAppType() + 1;
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)objectId));
        long count = this.decorator.remove(query, AssemblyApplicationConfigEntity.class);
        return count > 0L;
    }

    @Override
    public boolean existsByKey(String code, String name, String excludeId) {
        Assert.isFalse((boolean)StrUtil.isAllBlank((CharSequence[])new CharSequence[]{code, name}), (String)"code or name can not be null", (Object[])new Object[0]);
        Query query = new Query();
        if (StrUtil.isNotBlank((CharSequence)code)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        }
        if (excludeId != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").ne((Object)excludeId));
        }
        return this.decorator.count(query, AssemblyApplicationConfigEntity.class) > 0L;
    }

    @Override
    public Pagination<SolutionPlanListDTO> selectPage(PageReqCondition<SolutionPlanPageQo> pageParam) {
        Query query = new Query();
        this.buildPageCondition(pageParam, query);
        return this.decorator.findWithPage(query, AssemblyApplicationConfigEntity.class, pageParam).convert(SolutionConvertor.INSTANCE::entityToListDTO);
    }

    protected void buildPageCondition(PageReqCondition<SolutionPlanPageQo> pageParam, Query query) {
        SolutionPlanPageQo condition = (SolutionPlanPageQo)ObjectUtil.defaultIfNull((Object)((SolutionPlanPageQo)pageParam.getCondition()), SolutionPlanPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        if (CollUtil.isNotEmpty(condition.getAssemblyTypeList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assemblyType").in(condition.getAssemblyTypeList()));
        }
        if (CollUtil.isNotEmpty(condition.getSolutionStateList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(condition.getSolutionStateList()));
        }
    }

    @Override
    public Map<String, Set<SolutionPlanListDTO>> findListByDesignerId(Iterable<String> designerIdColl) {
        LinkedHashSet<String> designerIdSet = new LinkedHashSet<String>();
        designerIdColl.forEach(designerIdSet::add);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"designerList.id").in(designerIdSet));
        List solutionList = this.decorator.find(query, AssemblyApplicationConfigEntity.class);
        return this.groupByDesignerId(solutionList, designerIdSet);
    }

    protected Map<String, Set<SolutionPlanListDTO>> groupByDesignerId(List<AssemblyApplicationConfigEntity> solutionList, Set<String> designerIdSet) {
        HashMap designerSolutionMap = MapUtil.newHashMap((int)designerIdSet.size());
        for (AssemblyApplicationConfigEntity solution : solutionList) {
            if (solution.getDesignerList() == null) continue;
            for (SolutionPlanDetailDTO.DesignerBaseInfoDTO designerInfo : solution.getDesignerList()) {
                if (!designerIdSet.contains(designerInfo.getId())) continue;
                designerSolutionMap.computeIfAbsent(designerInfo.getId(), k -> new HashSet()).add(solution);
            }
        }
        return MapUtil.map((Map)designerSolutionMap, (k, v) -> SolutionConvertor.INSTANCE.entitySetToListDTO((Set<AssemblyApplicationConfigEntity>)v));
    }

    @Generated
    public DSolutionMongoDaoImpl(MongoPrimaryRepositoryDecorator decorator) {
        this.decorator = decorator;
    }
}

