/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.asset.DesignerAssetListReqDto;
import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AssetMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void save(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.save((Object)asset);
    }

    public Asset findOne(String assetId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId));
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> findByApplication(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"manageContext.application").is((Object)application));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> findByAssetIds(List<String> assetIds) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").in(assetIds));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public void delete(String assetId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId));
        this.mongoPrimaryRepositoryDecorator.delete(query, Asset.class);
    }

    public void insert(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)asset);
    }

    public void delete(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.delete((Object)asset);
    }

    public List<Asset> selectByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application).and("code").is((Object)code);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Asset selectByAssetIdAndSourceBranchAndAdpVersion(String assetId, String sourceBranch, String adpVersion) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("manageContext.branch").is((Object)sourceBranch).and("manageContext.adpVersion").is((Object)adpVersion);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void updateDraftAdpStatusByAssetId(String editBy, String assetId) {
        Update update = new Update();
        update.set("manageContext.adpStatus", (Object)"draft");
        update.set("editDate", (Object)new Date());
        update.set("editBy", (Object)editBy);
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("manageContext.adpStatus").is((Object)"effect");
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, Asset.class);
    }

    public Asset selectEffectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("manageContext.adpStatus").is((Object)"effect");
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectEffectByAssetIds(Collection<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("manageContext.adpStatus").is((Object)"effect");
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectBasicInfoByObjectId(List<String> objIds) {
        Criteria criteria = Criteria.where((String)"_id").in(objIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"businessData", "content"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public Asset selectByObjectId(String objId) {
        Criteria criteria = Criteria.where((String)"_id").is((Object)objId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> selectByCodeAndApplicationAndSourceBranchAndAdpVersion(Asset asset) {
        Criteria criteria = Criteria.where((String)"code").is((Object)asset.getCode()).and("manageContext.application").is((Object)asset.getManageContext().getApplication()).and("manageContext.branch").is((Object)asset.getManageContext().getBranch());
        if (StringUtils.isNotEmpty((CharSequence)asset.getManageContext().getAdpVersion())) {
            criteria.and("manageContext.adpVersion").is((Object)asset.getManageContext().getAdpVersion());
        }
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void deleteByCodeAndApplicationAndSourceBranchAndAdpVersion(Asset asset) {
        Criteria criteria = Criteria.where((String)"code").is((Object)asset.getCode()).and("manageContext.application").is((Object)asset.getManageContext().getApplication()).and("manageContext.branch").is((Object)asset.getManageContext().getBranch());
        if (StringUtils.isNotEmpty((CharSequence)asset.getManageContext().getAdpVersion())) {
            criteria.and("manageContext.adpVersion").is((Object)asset.getManageContext().getAdpVersion());
        }
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Asset selectLatestVersionByAssetIdAndSourceBranchAndApplication(String assetId, String branch, String application) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("manageContext.application").is((Object)application).and("manageContext.branch").is((Object)branch);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"manageContext.adpVersion"}));
        query.limit(1);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public Asset selectAssetIdByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application).and("code").is((Object)code);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        query.limit(1);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> selectByApplicationAndAdpVersionAndBranch(String application, String adpVersion, String branch) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application);
        if (StringUtils.isNotEmpty((CharSequence)adpVersion)) {
            criteria.and("manageContext.adpVersion").is((Object)adpVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)branch)) {
            criteria.and("manageContext.branch").is((Object)branch);
        }
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<String> selectAllId() {
        Query query = new Query();
        query.fields().include("_id");
        return this.mongoPrimaryRepositoryDecorator.find(new Query(), Asset.class).stream().map(Asset::getObjectId).collect(Collectors.toList());
    }

    public Long selectEffectCount(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("manageContext.adpStatus").is((Object)VersionStatusEnum.RUN_STATE.getCode());
        return this.mongoPrimaryRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Set<String> selectExistAssetId(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class).stream().map(Asset::getAssetId).collect(Collectors.toSet());
    }

    public Asset selectLastOneNew(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("manageContext.branch").is((Object)"develop");
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectByApplicationAndBranch(String application, String branch) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application).and("manageContext.branch").is((Object)branch);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void insertAll(List<Asset> assetList) {
        this.mongoPrimaryRepositoryDecorator.insertAll(assetList);
    }

    public void deleteByApplicationAndBranch(String application, String branch) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application).and("manageContext.branch").is((Object)branch);
        this.mongoPrimaryRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void updateDraftByApplicationAndType(String application, AssetDefinition.AssetTypeEnum assetTypeEnum) {
        Criteria criteria = Criteria.where((String)"manageContext.application").is((Object)application).and("type").is((Object)assetTypeEnum.getCode());
        Update update = new Update();
        update.set("manageContext.adpStatus", (Object)"draft");
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, Asset.class);
    }

    public List<Asset> selectEffectVersionByAssetIds(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("manageContext.adpStatus").is((Object)"effect");
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"assetId", "manageContext.adpVersion", "showFields.adpRemarkNumber"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> selectByIds(List<String> objIds) {
        Criteria criteria = Criteria.where((String)"_id").in(objIds);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> selectBasicInfoByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"businessData", "content"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> selectVersionInfo(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("assetId");
        fields.include("manageContext.adpVersion");
        fields.include("manageContext.branch");
        fields.include("showFields.adpRemarkNumber");
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> findByAssetIdsAndBranch(List<String> assetIds, String branch) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").in(assetIds).and("manageContext.branch").is((Object)branch).and("manageContext.adpStatus").is((Object)VersionStatusEnum.RUN_STATE.getCode()));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public Asset selectByAssetIdAndManageContext(String assetId, Asset.ManageContext manageContext) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        if (manageContext != null) {
            if (!StringUtils.isEmpty((CharSequence)manageContext.getAdpVersion())) {
                criteria.and("manageContext.adpVersion").is((Object)manageContext.getAdpVersion());
            }
            if (!StringUtils.isEmpty((CharSequence)manageContext.getBranch())) {
                criteria.and("manageContext.adpStatus").is((Object)manageContext.getAdpVersion());
            }
        }
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Long countDesignerAssetPagination(PageReqCondition<DesignerAssetListReqDto> pageReqCondition) {
        DesignerAssetListReqDto condition = (DesignerAssetListReqDto)pageReqCondition.getCondition();
        PageReqCondition newPageReqCondition = new PageReqCondition();
        newPageReqCondition.setCondition((Object)condition.getSearchContent());
        Criteria criteria = this.buildAdvancedCondition((PageReqCondition<String>)newPageReqCondition);
        Asset.ManageContext manageContext = condition.getManageContext();
        List<String> types = condition.getTypes();
        Criteria manageContextCriteria = new Criteria();
        if (StringUtils.isEmpty((CharSequence)manageContext.getApplication())) {
            manageContextCriteria.and("manageContext.application").isNull();
        } else {
            manageContextCriteria.and("manageContext.application").is((Object)manageContext.getApplication());
        }
        if (StringUtils.isEmpty((CharSequence)manageContext.getBranch())) {
            manageContextCriteria.and("manageContext.branch").isNull();
        } else {
            manageContextCriteria.and("manageContext.branch").is((Object)manageContext.getBranch());
        }
        if (StringUtils.isEmpty((CharSequence)manageContext.getAdpVersion())) {
            manageContextCriteria.and("manageContext.adpVersion").isNull();
        } else {
            manageContextCriteria.and("manageContext.adpVersion").is((Object)manageContext.getAdpVersion());
        }
        if (criteria == null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{manageContextCriteria});
            if (!CollectionUtils.isEmpty(types)) {
                criteria = criteria.and("type").in(types);
            }
        } else {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(criteria);
            criteriaList.add(manageContextCriteria);
            if (!CollectionUtils.isEmpty(types)) {
                criteriaList.add(Criteria.where((String)"type").in(types));
            }
            criteria = new Criteria().andOperator(criteriaList);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.count(query, Asset.class);
    }

    public List<Asset> selectDesignerAssetPagination(PageReqCondition<DesignerAssetListReqDto> pageReqCondition) {
        DesignerAssetListReqDto condition = (DesignerAssetListReqDto)pageReqCondition.getCondition();
        PageReqCondition newPageReqCondition = new PageReqCondition();
        newPageReqCondition.setCondition((Object)condition.getSearchContent());
        Criteria criteria = this.buildAdvancedCondition((PageReqCondition<String>)newPageReqCondition);
        Asset.ManageContext manageContext = condition.getManageContext();
        List<String> types = condition.getTypes();
        Criteria manageContextCriteria = new Criteria();
        if (StringUtils.isEmpty((CharSequence)manageContext.getApplication())) {
            manageContextCriteria.and("manageContext.application").isNull();
        } else {
            manageContextCriteria.and("manageContext.application").is((Object)manageContext.getApplication());
        }
        if (StringUtils.isEmpty((CharSequence)manageContext.getBranch())) {
            manageContextCriteria.and("manageContext.branch").isNull();
        } else {
            manageContextCriteria.and("manageContext.branch").is((Object)manageContext.getBranch());
        }
        if (StringUtils.isEmpty((CharSequence)manageContext.getAdpVersion())) {
            manageContextCriteria.and("manageContext.adpVersion").isNull();
        } else {
            manageContextCriteria.and("manageContext.adpVersion").is((Object)manageContext.getAdpVersion());
        }
        if (criteria == null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{manageContextCriteria});
            if (!CollectionUtils.isEmpty(types)) {
                criteria = criteria.and("type").in(types);
            }
        } else {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(criteria);
            criteriaList.add(manageContextCriteria);
            if (!CollectionUtils.isEmpty(types)) {
                criteriaList.add(Criteria.where((String)"type").in(types));
            }
            criteria = new Criteria().andOperator(criteriaList);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    private Criteria buildAdvancedCondition(PageReqCondition<String> pageReqCondition) {
        Criteria adVancedCriteria;
        Criteria criteria = null;
        if (pageReqCondition.getAdvancedQueryParams() != null && (adVancedCriteria = pageReqCondition.getAdvancedQueryParams().buildCriteria()) != null) {
            criteria = adVancedCriteria;
        }
        if (criteria == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pageReqCondition.getCondition()))) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote((String)pageReqCondition.getCondition()) + ".*", 2);
            criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"assetId").regex(pattern), Criteria.where((String)"code").regex(pattern), Criteria.where((String)"assetName").regex(pattern), Criteria.where((String)"assetDesc").regex(pattern)});
        }
        return criteria;
    }
}

