/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class ExpressionResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpressionResolver.class);
    @Autowired
    private Environment environment;
    private final ExpressionParser parser = new SpelExpressionParser();

    public String resolve(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        try {
            StandardEvaluationContext context = this.createEvaluationContext();
            Expression exp = this.parser.parseExpression(text);
            Object value = exp.getValue((EvaluationContext)context);
            return value != null ? value.toString() : text;
        }
        catch (Exception e) {
            String value = this.environment.getProperty(text);
            if (value != null) {
                return value;
            }
            log.debug("\u65e0\u6cd5\u89e3\u6790\u8868\u8fbe\u5f0f: {}, \u4fdd\u6301\u539f\u503c", (Object)text);
            return text;
        }
    }

    public Map<String, Object> resolve(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                result.put(key, this.resolve((String)value));
                continue;
            }
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                result.put(key, this.resolve(nestedMap));
                continue;
            }
            if (value instanceof List) {
                result.put(key, this.resolveList((List)value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public List<Object> resolveList(List<?> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        return list.stream().map(item -> {
            if (item instanceof String) {
                return this.resolve((String)item);
            }
            if (item instanceof Map) {
                Map map = (Map)item;
                return this.resolve(map);
            }
            return item;
        }).collect(Collectors.toList());
    }

    private StandardEvaluationContext createEvaluationContext() {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("env", (Object)new EnvironmentAccessor(this.environment));
        return context;
    }

    private static class EnvironmentAccessor {
        private final Environment environment;

        public EnvironmentAccessor(Environment environment) {
            this.environment = environment;
        }

        public String get(String key) {
            return this.environment.getProperty(key);
        }

        public String getOrDefault(String key, String defaultValue) {
            return this.environment.getProperty(key, defaultValue);
        }
    }
}

