package com.digiwin.athena.datacollect.api.dto;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.mongodb.domain.application.Asset;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 资产实例数据采集API响应
 * 对应平台标准HTTP接口规范
 */
@Slf4j
@Data
public class AssetCollectApiResponse {

    /**
     * 响应码
     */
    private Integer code;

    /**
     * 响应数据
     */
    private List<AssetDataItem> data;

    @Data
    public static class AssetDataItem {
        /**
         * TODO pzz refactor定义操作类型枚举，并替换代码中的使用
         * 操作类型: insert/update/delete/upsert
         */
        private String op;

        /**
         * 资产数据
         */
        private AssetData data;


        public String obtainOp(String contextOp, String assetId) {
            // 设置操作类型（用于判断是插入、更新还是删除）
            // 优先使用item的op,如果没有则从context中获取
            String op = getOp();

            // 如果两者都存在但不一致，记录警告日志
            if (StrUtil.isNotBlank(op) && StrUtil.isNotBlank(contextOp) && !op.equals(contextOp)) {
                log.warn("操作类型不一致: item.op={}, context.op={}, assetId={}, 将使用item.op",
                        op, contextOp, assetId);
            }

            // 如果item的op为空，则使用context中的op
            if (StrUtil.isBlank(op)) {
                op = contextOp;
            }

            // 根据op类型，将assetId添加到对应的集合中
            if (StrUtil.isNotBlank(op)) {
                op = "upsert";
                log.warn("操作类型为空!: assetId={},type:{},code:{}", assetId, getData().getType(), getData()
                        .getCode());
            }
            return op;
        }
    }

    @Data
    public static class AssetData {
        /**
         * 业务方编号（全局唯一）
         */
        private String code;

        /**
         * 资产类型
         */
        private String type;

        /**
         * 资产名称
         */
        private String assetName;

        /**
         * 资产描述
         */
        private String assetDesc;

        /**
         * 管理字段（业务方与平台方共同制定）
         */
        private Asset.ManageContext manageContext;

        /**
         * 归属租户
         */
        private String adpTenantId;

        /**
         * 业务数据（业务方定义）
         */
        private String businessData;

        /**
         * 修改时间
         * TODO: 可能需要从manageContext中获取修改时间字段，具体实现待业务方确认
         */
        private LocalDateTime editDate;
    }

    public boolean success(){
        return code == 0;
    }
}
