/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.collector.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiRequest;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.collector.BaseAssetDataCollector;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.context.HttpScriptContext;
import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import com.digiwin.athena.datacollect.model.PageResult;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpAssetDataCollector
extends BaseAssetDataCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpAssetDataCollector.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected final RestTemplate restTemplate;

    @Override
    public String getType() {
        return "http";
    }

    @Override
    protected PageResult<AssetCollectApiResponse.AssetDataItem> fetchPage(CollectContext context) {
        CollectExecutorProp executor = context.getConfig().getExecutor();
        String url = executor.getUrl();
        try {
            Map<String, Object> headerMap = new HashMap<String, Object>(MapUtil.emptyIfNull(executor.getHeaders()));
            AssetCollectApiRequest request = this.buildRequest(context);
            RequestScriptResult scriptResult = this.processRequestScript(executor, context, url, request, headerMap);
            request = scriptResult.getRequest();
            headerMap = scriptResult.getHeaderMap();
            HttpHeaders headers = this.buildHeaders(headerMap);
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            if (log.isDebugEnabled()) {
                log.debug("HTTP\u8bf7\u6c42\u53c2\u6570\uff1a url:{},header:{},body:{}", new Object[]{url, BaseConverter.INSTANCE.serialize(headers), BaseConverter.INSTANCE.serialize(request)});
            }
            RetryTemplate dynamicRetryTemplate = this.createRetryTemplate(executor);
            ResponseEntity response = (ResponseEntity)dynamicRetryTemplate.execute(this.request(url, (HttpEntity<AssetCollectApiRequest>)entity));
            String responseBodyStr = (String)response.getBody();
            if (log.isDebugEnabled()) {
                log.debug("HTTP\u8bf7\u6c42\u54cd\u5e94\uff1a url:{},status:{},body:{}", new Object[]{url, response.getStatusCode(), responseBodyStr});
            }
            if (response.getStatusCode().is2xxSuccessful() && StrUtil.isNotBlank((CharSequence)responseBodyStr)) {
                AssetCollectApiResponse responseBody = this.processResponseScript(executor, context, responseBodyStr, response.getHeaders());
                return this.convertToPageResult(responseBody, context.getPageNo(), context.getPageSize());
            }
            log.error("HTTP\u8bf7\u6c42\u5931\u8d25: status={}, url={},body:{}", new Object[]{response.getStatusCode(), url, responseBodyStr});
            return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), context.getPageNo(), context.getPageSize());
        }
        catch (Exception e) {
            log.error("HTTP\u6570\u636e\u91c7\u96c6\u5931\u8d25: assetType={}, url={}, pageNo={}", new Object[]{context.getAssetType(), url, context.getPageNo(), e});
            throw e;
        }
    }

    protected RetryCallback<ResponseEntity<String>, RuntimeException> request(String url, HttpEntity<AssetCollectApiRequest> entity) {
        return retryContext -> {
            log.debug("\u53d1\u9001HTTP\u8bf7\u6c42: url={}, attempt={}", (Object)url, (Object)(retryContext.getRetryCount() + 1));
            return this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        };
    }

    protected RequestScriptResult processRequestScript(CollectExecutorProp executor, CollectContext context, String url, AssetCollectApiRequest request, Map<String, Object> headerMap) {
        if (executor.getRequestScript() != null && !executor.getRequestScript().trim().isEmpty()) {
            HttpScriptContext scriptContext = new HttpScriptContext(context);
            scriptContext.setUrl(url);
            scriptContext.setRequestBody(request);
            scriptContext.setRequestHeader(headerMap);
            HttpScriptContext resultContext = this.scriptExecutor.execute(executor.getRequestScript(), BeanUtil.beanToMap((Object)scriptContext, (String[])new String[0]), HttpScriptContext.class);
            return new RequestScriptResult(resultContext.getRequestBody(), resultContext.getRequestHeader());
        }
        return new RequestScriptResult(request, headerMap);
    }

    protected AssetCollectApiResponse processResponseScript(CollectExecutorProp executor, CollectContext context, String responseBodyStr, HttpHeaders responseHeaders) {
        if (executor.getResponseScript() != null && !executor.getResponseScript().trim().isEmpty()) {
            Map responseBodyMap = this.scriptExecutor.convertResult(responseBodyStr, Map.class);
            HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
            if (responseHeaders != null) {
                responseHeaders.forEach((key, values) -> {
                    if (values != null && !values.isEmpty()) {
                        responseHeaderMap.put((String)key, (String)values.get(0));
                    }
                });
            }
            HttpScriptContext scriptContext = new HttpScriptContext(context);
            scriptContext.setResponseBody(responseBodyMap);
            scriptContext.setResponseHeader(responseHeaderMap);
            HttpScriptContext resultContext = this.scriptExecutor.execute(executor.getResponseScript(), BeanUtil.beanToMap((Object)scriptContext, (String[])new String[0]), HttpScriptContext.class);
            if (resultContext != null) {
                return this.scriptExecutor.convertResult(resultContext.getResponseBody(), AssetCollectApiResponse.class);
            }
        }
        return this.scriptExecutor.convertResult(responseBodyStr, AssetCollectApiResponse.class);
    }

    protected RetryTemplate createRetryTemplate(CollectExecutorProp executor) {
        RetryTemplate template = new RetryTemplate();
        CollectExecutorProp.RetryConfig retryConfig = executor.getRetry();
        if (retryConfig == null || !Boolean.TRUE.equals(retryConfig.getEnabled())) {
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
            retryPolicy.setMaxAttempts(1);
            template.setRetryPolicy((RetryPolicy)retryPolicy);
            return template;
        }
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
        retryPolicy.setMaxAttempts(retryConfig.getMaxAttempts() != null ? retryConfig.getMaxAttempts() : 3);
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        if (retryConfig.getMultiplier() != null && retryConfig.getMultiplier() > 1.0) {
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            backOffPolicy.setInitialInterval(retryConfig.getInterval() != null ? retryConfig.getInterval() : 2000L);
            backOffPolicy.setMaxInterval(retryConfig.getMaxInterval() != null ? retryConfig.getMaxInterval() : 10000L);
            backOffPolicy.setMultiplier(retryConfig.getMultiplier().doubleValue());
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            log.debug("\u914d\u7f6e\u6307\u6570\u9000\u907f\u7b56\u7565: initialInterval={}ms, maxInterval={}ms, multiplier={}", new Object[]{backOffPolicy.getInitialInterval(), backOffPolicy.getMaxInterval(), backOffPolicy.getMultiplier()});
        } else {
            FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
            backOffPolicy.setBackOffPeriod(retryConfig.getInterval() != null ? retryConfig.getInterval() : 2000L);
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            log.debug("\u914d\u7f6e\u56fa\u5b9a\u9000\u907f\u7b56\u7565: interval={}ms", (Object)backOffPolicy.getBackOffPeriod());
        }
        return template;
    }

    protected HttpHeaders buildHeaders(Map<String, Object> headersConfig) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (headersConfig != null && !headersConfig.isEmpty()) {
            for (Map.Entry<String, Object> entry : headersConfig.entrySet()) {
                headers.set(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return headers;
    }

    protected AssetCollectApiRequest buildRequest(CollectContext context) {
        Object op;
        AssetCollectApiRequest request = new AssetCollectApiRequest();
        request.setAssetType(context.getAssetType().getType());
        request.setPageNo(context.getPageNo());
        request.setPageSize(context.getPageSize());
        if (context.getCurrentStepStartTime() != null) {
            request.setStartTime(context.getCurrentStepStartTime().format(DATE_TIME_FORMATTER));
        }
        if (context.getCurrentStepEndTime() != null) {
            request.setEndTime(context.getCurrentStepEndTime().format(DATE_TIME_FORMATTER));
        }
        if (context.getLoopParam() != null && !context.getLoopParam().isEmpty() && (op = context.getLoopParam().get("op")) != null) {
            request.setOp(String.valueOf(op));
        }
        return request;
    }

    protected PageResult<AssetCollectApiResponse.AssetDataItem> convertToPageResult(AssetCollectApiResponse apiResponse, Integer pageNo, int pageSize) {
        if (apiResponse == null || !apiResponse.success()) {
            log.warn("HTTP\u63a5\u53e3\u8fd4\u56de\u975e\u6210\u529f\u72b6\u6001: code={}", (Object)(apiResponse != null ? apiResponse.getCode() : null));
            return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), pageNo, pageSize);
        }
        List<AssetCollectApiResponse.AssetDataItem> dataItems = apiResponse.getData();
        if (CollectionUtils.isEmpty(dataItems)) {
            return new PageResult<AssetCollectApiResponse.AssetDataItem>(new ArrayList(), pageNo, pageSize);
        }
        boolean hasMore = dataItems.size() >= pageSize;
        PageResult<AssetCollectApiResponse.AssetDataItem> pageResult = new PageResult<AssetCollectApiResponse.AssetDataItem>();
        pageResult.setData(dataItems);
        pageResult.setHasMore(hasMore);
        pageResult.setCurrentPage(pageNo);
        pageResult.setCurrentPageSize(dataItems.size());
        return pageResult;
    }

    @Generated
    public HttpAssetDataCollector(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected static class RequestScriptResult {
        private final AssetCollectApiRequest request;
        private final Map<String, Object> headerMap;

        public RequestScriptResult(AssetCollectApiRequest request, Map<String, Object> headerMap) {
            this.request = request;
            this.headerMap = headerMap;
        }

        @Generated
        public AssetCollectApiRequest getRequest() {
            return this.request;
        }

        @Generated
        public Map<String, Object> getHeaderMap() {
            return this.headerMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestScriptResult)) {
                return false;
            }
            RequestScriptResult other = (RequestScriptResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AssetCollectApiRequest this$request = this.getRequest();
            AssetCollectApiRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            Map<String, Object> this$headerMap = this.getHeaderMap();
            Map<String, Object> other$headerMap = other.getHeaderMap();
            return !(this$headerMap == null ? other$headerMap != null : !((Object)this$headerMap).equals(other$headerMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestScriptResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AssetCollectApiRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            Map<String, Object> $headerMap = this.getHeaderMap();
            result = result * 59 + ($headerMap == null ? 43 : ((Object)$headerMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpAssetDataCollector.RequestScriptResult(request=" + String.valueOf(this.getRequest()) + ", headerMap=" + String.valueOf(this.getHeaderMap()) + ")";
        }
    }
}

