/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.job;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.convertor.assembly.DataCollectorConverter;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dao.mongodao.datacollect.JobExecutionRecordMongoDao;
import com.digiwin.athena.datacollect.collector.BaseAssetDataCollector;
import com.digiwin.athena.datacollect.consumer.CollectDataConsumer;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import com.digiwin.athena.datacollect.model.CollectResult;
import com.digiwin.athena.datacollect.model.JobBizData;
import com.digiwin.athena.datacollect.model.JobExecData;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mongodb.domain.datacollect.JobExecutionRecord;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AssetDataCollectJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataCollectJob.class);
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final long DEFAULT_STEP_SIZE_MINUTES = 43200L;
    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;
    @Autowired
    private JobExecutionRecordMongoDao jobExecutionRecordMongoDao;
    @Autowired
    private AssetDataCollectService assetDataCollectService;
    @Autowired
    private List<BaseAssetDataCollector> collectors;
    private Map<String, BaseAssetDataCollector> collectorMap;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.collectorMap == null) {
            this.collectorMap = this.collectors.stream().collect(Collectors.toMap(BaseAssetDataCollector::getType, c -> c));
        }
        String assetTypeId = context.getJobDetail().getJobDataMap().getString("assetTypeId");
        JobExecutionRecord record = this.initExecRecord(context, assetTypeId);
        CollectContext collectContext = null;
        log.info("\u5f00\u59cb\u6267\u884c\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1: jobName={}, assetTypeId={}", (Object)record.getJobName(), (Object)assetTypeId);
        try {
            AssetType assetType = this.rAssetTypeMongoDao.selectById(assetTypeId);
            if (assetType == null) {
                throw new JobExecutionException("\u8d44\u4ea7\u7c7b\u578b\u4e0d\u5b58\u5728: " + assetTypeId);
            }
            DataCollectConfig config = (DataCollectConfig)JSONObject.parseObject((String)assetType.getDataCollectConfig().toJSONString(), DataCollectConfig.class);
            if (config == null || config.getExecutor() == null) {
                throw new JobExecutionException("\u8d44\u4ea7\u7c7b\u578b\u672a\u914d\u7f6e\u6570\u636e\u91c7\u96c6: " + assetType.getType());
            }
            JobExecutionRecord lastRecord = this.jobExecutionRecordMongoDao.findLatestByBizKey(assetTypeId);
            JobExecData presetExecData = lastRecord != null ? lastRecord.getNextExecData() : null;
            boolean configChanged = this.isConfigChanged(config, lastRecord);
            if (configChanged) {
                log.warn("\u68c0\u6d4b\u5230\u914d\u7f6e\u66f4\u65b0\uff0c\u7ed3\u675f\u5f53\u524d\u4efb\u52a1\u5e76\u91cd\u65b0\u5f00\u59cb: assetTypeId={}, oldConfigTime={}, newConfigTime={}", new Object[]{assetTypeId, Optional.ofNullable(lastRecord).map(JobExecutionRecord::getBizData).map(JobBizData::getConfigUpdateTime).orElse(null), config.getConfigUpdateTime()});
                presetExecData = null;
            }
            LocalDateTime fireTime = LocalDateTimeUtil.of((Date)context.getFireTime());
            collectContext = this.buildCollectContext(assetType, config, presetExecData, fireTime);
            String executorType = config.getExecutor().getType();
            BaseAssetDataCollector collector = this.collectorMap.get(executorType);
            if (collector == null) {
                throw new JobExecutionException("\u4e0d\u652f\u6301\u7684\u91c7\u96c6\u5668\u7c7b\u578b: " + executorType);
            }
            CollectDataConsumer consumer = this.assetDataCollectService::batchProcessDataItems;
            CollectResult result = collector.collect(collectContext, consumer);
            this.completeRecord(record, result, assetType, config, collectContext);
            log.info("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u6267\u884c\u5b8c\u6210: jobRecord\uff1a{}", (Object)record);
        }
        catch (Exception e) {
            this.failRecord(record, e.getMessage(), collectContext);
            log.error("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u6267\u884c\u5931\u8d25: jobRecord{}", (Object)record, (Object)e);
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            this.jobExecutionRecordMongoDao.save(record);
        }
    }

    protected void failRecord(JobExecutionRecord record, String message, CollectContext collectContext) {
        record.setStatus("FAILURE");
        record.setFinishTime(LocalDateTime.now());
        record.setErrorMessage(message);
        record.setDurationMs(ChronoUnit.MILLIS.between(record.getFireTime(), record.getFinishTime()));
        if (collectContext != null) {
            JobExecData failedNextData = this.buildFailedNextData(collectContext);
            record.setNextExecData(failedNextData);
        }
    }

    protected void completeRecord(JobExecutionRecord record, CollectResult result, AssetType assetType, DataCollectConfig config, CollectContext collectContext) {
        record.setStatus(result.isSuccess() ? "SUCCESS" : "FAILURE");
        record.setFinishTime(result.getEndTime());
        record.setDurationMs(result.getDurationMs());
        JobBizData bizData = this.buildBizData(assetType, config, collectContext);
        record.setBizData(bizData);
        JobExecData nextData = this.buildNextData(result, collectContext);
        record.setNextExecData(nextData);
        if (!result.isSuccess()) {
            record.setErrorMessage(result.getErrorMessage());
        }
    }

    protected JobExecutionRecord initExecRecord(JobExecutionContext context, String assetTypeId) {
        JobExecutionRecord record = new JobExecutionRecord();
        record.setJobName(context.getJobDetail().getKey().getName());
        record.setBizKey(assetTypeId);
        record.setFireTime(LocalDateTimeUtil.of((Date)context.getFireTime()));
        record.setCreatedAt(LocalDateTime.now());
        record.setStatus("RUNNING");
        return record;
    }

    protected CollectContext buildCollectContext(AssetType assetType, DataCollectConfig config, JobExecData presetExecData, LocalDateTime fireTime) {
        CollectExecutorProp executor = config.getExecutor();
        int pageSize = executor.getPageSize() != null ? executor.getPageSize() : 100;
        Long stepSizeMinutes = executor.getStepSizeMinutes() != null ? executor.getStepSizeMinutes() : 43200L;
        CollectContext context = new CollectContext();
        context.setAssetTypeId(assetType.getObjId());
        context.setAssetType(assetType);
        context.setConfig(config);
        context.setStepSizeMinutes(stepSizeMinutes);
        context.init(pageSize);
        if (presetExecData != null) {
            DataCollectorConverter.INSTANCE.merge(presetExecData, context);
            log.info("\u7eed\u67e5\u4efb\u52a1:  assetTypeId={}, context:{}", (Object)assetType.getObjId(), (Object)context);
        } else {
            context.setStartTime(LocalDateTime.now().minusYears(3L));
            log.info("\u9996\u6b21\u6267\u884c\u4efb\u52a1: assetTypeId={}, startTime={}", (Object)assetType.getObjId(), (Object)context.getStartTime());
        }
        if (context.getEndTime() == null) {
            context.setEndTime(fireTime);
        }
        context.setFireTime(fireTime);
        return context;
    }

    protected boolean isConfigChanged(DataCollectConfig config, JobExecutionRecord lastRecord) {
        if (config.getConfigUpdateTime() == null) {
            return false;
        }
        if (lastRecord == null || lastRecord.getBizData() == null) {
            return false;
        }
        LocalDateTime lastConfigTime = lastRecord.getBizData().getConfigUpdateTime();
        if (lastConfigTime == null) {
            return true;
        }
        return !config.getConfigUpdateTime().equals(lastConfigTime);
    }

    protected JobBizData buildBizData(AssetType assetType, DataCollectConfig config, CollectContext context) {
        JobBizData bizData = new JobBizData();
        bizData.setAssetTypeId(assetType.getObjId());
        bizData.setAssetType(assetType.getType());
        bizData.setAssetTypeName(assetType.getName());
        bizData.setStatus(assetType.getStatus());
        bizData.setConfigUpdateTime(config.getConfigUpdateTime());
        bizData.setTotalCount(context.getTotalRecords());
        bizData.setConsumedCount(context.getConsumedRecords());
        bizData.setTotalPages(context.getTotalPages());
        bizData.setTotalSteps(context.getTotalSteps());
        return bizData;
    }

    protected JobExecData buildNextData(CollectResult result, CollectContext context) {
        JobExecData nextData = new JobExecData();
        if (result.isSuccess()) {
            nextData.setLastCollectTime(result.getEndTime());
            nextData.setStartTime(context.getCurrentStepEndTime());
        } else {
            nextData.setLastCollectTime(LocalDateTime.now());
            nextData.setStartTime(context.getStartTime());
            nextData.setEndTime(context.getEndTime());
            nextData.setPageNo(context.getPageNo());
            nextData.setLoopIndex(context.getLoopIndex());
            nextData.setStepStartTime(context.getCurrentStepStartTime());
            nextData.setStepEndTime(context.getCurrentStepEndTime());
        }
        return nextData;
    }

    protected JobExecData buildFailedNextData(CollectContext context) {
        JobExecData nextData = new JobExecData();
        nextData.setLastCollectTime(LocalDateTime.now());
        if (context != null) {
            nextData.setStartTime(context.getStartTime());
            nextData.setEndTime(context.getEndTime());
            nextData.setPageNo(context.getPageNo());
            nextData.setLoopIndex(context.getLoopIndex());
            nextData.setStepStartTime(context.getCurrentStepStartTime());
            nextData.setStepEndTime(context.getCurrentStepEndTime());
        }
        return nextData;
    }
}

