package com.digiwin.athena.mongodb.domain.datacollect;

import com.digiwin.athena.datacollect.model.JobBizData;
import com.digiwin.athena.datacollect.model.JobExecData;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;

/**
 * 任务执行记录日志
 */
@Data
@Document(collection = "job_execution_record")
public class JobExecutionRecord {

    /**
     * 主键
     */
    @Id
    private String id;

    /**
     * 任务名称
     */
    private String jobName;

    /**
     * 触发时间
     */
    private LocalDateTime fireTime;

    /**
     * 结束时间
     */
    private LocalDateTime finishTime;

    /**
     * 执行结果: SUCCESS/FAILURE/RUNNING
     */
    private String status;

    /**
     * 业务唯一标识（资产类型ID - AssetType.objId）
     */
    private String bizKey;

    /**
     * 业务数据
     */
    private JobBizData bizData;

    /**
     * 下次执行需要的数据
     */
    private JobExecData nextExecData;

    /**
     * 异常信息
     */
    private String errorMessage;

    /**
     * 执行耗时（毫秒）
     */
    private Long durationMs;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 执行状态常量
     */
    public static class Status {
        public static final String SUCCESS = "SUCCESS";
        public static final String FAILURE = "FAILURE";
        public static final String RUNNING = "RUNNING";
    }
}
