/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.datacollect;

import com.digiwin.athena.mongodb.domain.datacollect.JobExecutionRecord;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class JobExecutionRecordMongoDao {
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void save(JobExecutionRecord record) {
        this.mongoPrimaryRepositoryDecorator.save((Object)record);
    }

    public JobExecutionRecord findById(String id) {
        return (JobExecutionRecord)this.mongoPrimaryRepositoryDecorator.findById((Object)id, JobExecutionRecord.class);
    }

    public JobExecutionRecord findLatestByJobName(String jobName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        query.limit(1);
        List records = this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
        return records.isEmpty() ? null : (JobExecutionRecord)records.get(0);
    }

    public JobExecutionRecord findLatestByBizKey(String bizKey) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"bizKey").is((Object)bizKey));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        query.limit(1);
        List records = this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
        return records.isEmpty() ? null : (JobExecutionRecord)records.get(0);
    }

    public List<JobExecutionRecord> findByJobName(String jobName, int limit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jobName").is((Object)jobName));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        query.limit(limit);
        return this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
    }

    public List<JobExecutionRecord> findByBizKey(String bizKey, int limit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"bizKey").is((Object)bizKey));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        query.limit(limit);
        return this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
    }

    public List<JobExecutionRecord> findByTimeRange(Date startTime, Date endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"fireTime").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
    }

    public List<JobExecutionRecord> findByStatus(String status, int limit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)status));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fireTime"}));
        query.limit(limit);
        return this.mongoPrimaryRepositoryDecorator.find(query, JobExecutionRecord.class);
    }

    public long deleteOldRecords(int daysToKeep) {
        Date cutoffDate = new Date(System.currentTimeMillis() - (long)daysToKeep * 24L * 60L * 60L * 1000L);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdAt").lt((Object)cutoffDate));
        return this.mongoPrimaryRepositoryDecorator.remove(query, JobExecutionRecord.class);
    }
}

