package com.digiwin.athena.controller.assetType;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/assetType/r")
@Tag(name = "运行时资产类型接口",description = "2b425393-ae52-412d-95c4-7d1938f24b61")
public class RAssetTypeController {
    @Autowired
    private RAssetTypeService rAssetTypeService;

    @GetMapping("/assetTypeMenu")
    @Operation(summary = "获取资产类型菜单")
    public ResultDto<List<AssetTypeResDto>> assetTypeMenu(){
        List<AssetTypeResDto> res = rAssetTypeService.assetTypeMenu();
        return ResultDto.createSuccess(res);
    }
}
