package com.digiwin.athena.config;

import cn.hutool.extra.spring.SpringUtil;
import jakarta.annotation.PostConstruct;
import lombok.Data;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * Assembly模块配置属性
 */
@Data
public class AssemblyProp {

    /**
     * 全局应用token
     * `@Value("${rest-url.appToken:}")`
     */
    private String appToken;

    /**
     * IAM域名
     * `@Value("${module.iam.domain:}")`
     */
    private String iamDomain;

    /**
     * GMC域名
     * `@Value("${module.gmc.domain:}")`
     */
    private String gmcDomain;

    /**
     * 解决方案logo url
     */
    @NestedConfigurationProperty
    private SolutionProp solution = new SolutionProp();

    /**
     * 商品类别代码（ODM/lcdp）
     */
    private String productCode = "lcdp";

    @PostConstruct
    public void init() {
        if (appToken == null) {
            appToken = SpringUtil.getProperty("rest-url.appToken");
        }

        if (iamDomain == null) {
            iamDomain = SpringUtil.getProperty("module.iam.domain");
        }

        if (gmcDomain == null) {
            gmcDomain = SpringUtil.getProperty("module.gmc.domain");
        }

        if (solution.gmcLogoImgUrl == null) {
            solution.gmcLogoImgUrl = SpringUtil.getProperty("module.iam.app-logo");
        }
    }


    @Data
    public static class SolutionProp {
        /**
         * `@Value("${module.iam.app-logo}")`
         */
        private String gmcLogoImgUrl;
    }

    /**
     * 环境配置
     */
    @Data
    public static class EnvConfig {

        /**
         * IAM域名
         */
        private String iamDomain;

        /**
         * GMC域名
         */
        private String gmcDomain;
    }

}
