package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.mongodb.domain.application.AssetDepInfo;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class AssetDepInfoMongoDao {

    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public List<AssetDepInfo> selectBySourceId(String objId) {
        Criteria criteria = Criteria.where("sourceId").is(objId);
        return mongoPrimaryRepositoryDecorator.find(new Query(criteria),AssetDepInfo.class);
    }

    public void deleteBySourceId(String objId) {
        Criteria criteria = Criteria.where("sourceId").is(objId);
        mongoPrimaryRepositoryDecorator.delete(new Query(criteria),AssetDepInfo.class);
    }

    public void delete(AssetDepInfo depInfo) {
        mongoPrimaryRepositoryDecorator.delete(depInfo);
    }

    public void insert(List<AssetDepInfo> needInsertAssetDepInfos) {
        mongoPrimaryRepositoryDecorator.insert(needInsertAssetDepInfos);
    }
}
