package com.digiwin.athena.dto.assembly.solution;

import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.List;
import java.util.Map;

/**
 * 可组装解决方案配置
 */
@Data
public class SolutionPlanSaveDTO {

    /**
     * 主键ID
     */
    private String id;

    /**
     * 解决方案编码，全局唯一
     */
    @NotBlank
    @Length(max = 30)
    private String type;

    /**
     * 解决方案名称
     */
    @NotBlank
    @Length(max = 50)
    private String name;

    /**
     * 版本号，service层暂时写死1.0
     */
    private String version;

    /**
     * 描述
     */
    private String description;

    /**
     * 组装方式：dynamic(可组装)/static(不可组装)
     * @see AssemblyType#getCode()
     */
    private String assemblyType;

    /**
     * 归属方
     */
    private String owner;

    /**
     * 关联设计器列表
     */
    private List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList;

    /**
     * 布局配置
     */
    private Map<String, Object> canvas;

    /**
     * 布局方式
     */
    private String layoutMode;

    /**
     * SSO配置(不可组装页面配置)
     */
    private SolutionPlanDetailDTO.SsoConfigDTO ssoConfig;

    /**
     * 扩展配置字段 - 应用创建回调
     */
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appCreateCallback;

    /**
     * 扩展配置字段 - 应用更新回调
     */
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appUpdateCallback;

    /**
     * 扩展配置字段 - 编译回调
     */
    private List<SolutionPlanDetailDTO.AppCallBackDTO> compile;

    /**
     * 扩展配置字段 - 发布回调
     */
    private List<SolutionPlanDetailDTO.AppCallBackDTO> publish;

    /**
     * true走标准发布，对应的应用类型会在运维中心体现
     */
    private Boolean isStdPublish;

    /**
     * 多语言配置
     */
    private Map<String, MultiLanguageDTO<String>> lang;

    /**
     * 合并JSON字段，用于动态添加额外数据
     *
     * @see com.digiwin.athena.bo.assembly.SolutionPlan#getMergeJson
     */
    private Map<String, Object> mergeJson;
}
