package com.digiwin.athena.dto.asset;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetDepInfo;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Data
public class CreateAssetReqDto {

    private String assetId;
    // 资产类型
    private String type;

    private String code;


    private String businessData;

    private String assetName;

    private String assetDesc;

    private Map<String, MultiLanguageDTO> lang;

    private Asset.ManageContext manageContext = new Asset.ManageContext();
    private Asset.ShowField showFields = new Asset.ShowField();
    private List<AssetDepInfo> assetDepInfos = new ArrayList<>();

    public AssetDefinition convertAssetDefinition() {
        AssetDefinition assetDefinition = new AssetDefinition();
        assetDefinition.setType(this.type);
        assetDefinition.setCode(this.code);
        assetDefinition.setSource(AssetDefinition.SD_SOURCE);
        assetDefinition.setBusinessData(this.businessData);
        assetDefinition.setAssetName(this.assetName);
        assetDefinition.setAssetId(this.assetId);
        assetDefinition.setLang(lang);

        Asset.ManageContext manageContext1 = new Asset.ManageContext();
        manageContext1.setApplication(manageContext.getApplication());
        assetDefinition.setManageContext(manageContext1);


        return assetDefinition;
    }

    public Asset convertAsset() {
        Asset asset = new Asset();
        asset.setType(this.getType());
        asset.setCode(this.code);
        asset.setAssetName(this.assetName);
        asset.setBusinessData(this.businessData);
        asset.setManageContext(this.manageContext);
        asset.setShowFields(this.showFields);

        asset.setSource(AssetDefinition.SD_SOURCE);
        asset.setLang(this.lang);

        return asset;
    }
}
