/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.job;

import com.digiwin.athena.datacollect.job.AssetDataCollectJob;
import lombok.Generated;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuartzJobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobManager.class);
    private static final String JOB_GROUP = "AssetDataCollect";
    @Autowired
    private Scheduler scheduler;

    public boolean addOrUpdateJob(String assetTypeId, String cronExpression) {
        try {
            String jobName = this.buildJobName(assetTypeId);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP);
            if (this.scheduler.checkExists(jobKey)) {
                return this.updateJobCron(assetTypeId, cronExpression);
            }
            return this.addJob(assetTypeId, cronExpression);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u6216\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: assetTypeId={}, cron={}", new Object[]{assetTypeId, cronExpression, e});
            return false;
        }
    }

    public boolean addJob(String assetTypeId, String cronExpression) {
        try {
            String jobName = this.buildJobName(assetTypeId);
            JobDetail jobDetail = JobBuilder.newJob(AssetDataCollectJob.class).withIdentity(jobName, JOB_GROUP).usingJobData("assetTypeId", assetTypeId).storeDurably().build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.buildTriggerName(assetTypeId), JOB_GROUP).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            log.info("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: assetTypeId={}, cron={}", (Object)assetTypeId, (Object)cronExpression);
            return true;
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: assetTypeId={}, cron={}", new Object[]{assetTypeId, cronExpression, e});
            return false;
        }
    }

    public boolean updateJobCron(String assetTypeId, String cronExpression) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)this.buildTriggerName(assetTypeId), (String)JOB_GROUP);
            CronTrigger oldTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (oldTrigger == null) {
                log.warn("Trigger\u4e0d\u5b58\u5728,\u65e0\u6cd5\u66f4\u65b0: assetTypeId={}", (Object)assetTypeId);
                return false;
            }
            CronTrigger newTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.scheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            log.info("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1cron\u6210\u529f: assetTypeId={}, cron={}", (Object)assetTypeId, (Object)cronExpression);
            return true;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1cron\u5931\u8d25: assetTypeId={}, cron={}", new Object[]{assetTypeId, cronExpression, e});
            return false;
        }
    }

    public boolean pauseJob(String assetTypeId) {
        try {
            JobKey jobKey = JobKey.jobKey((String)this.buildJobName(assetTypeId), (String)JOB_GROUP);
            this.scheduler.pauseJob(jobKey);
            log.info("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: assetTypeId={}", (Object)assetTypeId);
            return true;
        }
        catch (Exception e) {
            log.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return false;
        }
    }

    public boolean resumeJob(String assetTypeId) {
        try {
            JobKey jobKey = JobKey.jobKey((String)this.buildJobName(assetTypeId), (String)JOB_GROUP);
            this.scheduler.resumeJob(jobKey);
            log.info("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: assetTypeId={}", (Object)assetTypeId);
            return true;
        }
        catch (Exception e) {
            log.error("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return false;
        }
    }

    public boolean deleteJob(String assetTypeId) {
        try {
            JobKey jobKey = JobKey.jobKey((String)this.buildJobName(assetTypeId), (String)JOB_GROUP);
            this.scheduler.deleteJob(jobKey);
            log.info("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f: assetTypeId={}", (Object)assetTypeId);
            return true;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return false;
        }
    }

    public boolean triggerJob(String assetTypeId) {
        try {
            JobKey jobKey = JobKey.jobKey((String)this.buildJobName(assetTypeId), (String)JOB_GROUP);
            this.scheduler.triggerJob(jobKey);
            log.info("\u624b\u52a8\u89e6\u53d1\u4efb\u52a1\u6210\u529f: assetTypeId={}", (Object)assetTypeId);
            return true;
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u89e6\u53d1\u4efb\u52a1\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return false;
        }
    }

    public boolean jobExists(String assetTypeId) {
        try {
            JobKey jobKey = JobKey.jobKey((String)this.buildJobName(assetTypeId), (String)JOB_GROUP);
            return this.scheduler.checkExists(jobKey);
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u4efb\u52a1\u662f\u5426\u5b58\u5728\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return false;
        }
    }

    public String getJobState(String assetTypeId) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)this.buildTriggerName(assetTypeId), (String)JOB_GROUP);
            Trigger.TriggerState state = this.scheduler.getTriggerState(triggerKey);
            return state.name();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4efb\u52a1\u72b6\u6001\u5931\u8d25: assetTypeId={}", (Object)assetTypeId, (Object)e);
            return "ERROR";
        }
    }

    private String buildJobName(String assetTypeId) {
        return "AssetDataCollect_" + assetTypeId;
    }

    private String buildTriggerName(String assetTypeId) {
        return "Trigger_" + assetTypeId;
    }
}

